#include "SpaceRebEngine.h"

SpaceRebEngine::SpaceRebEngine()
{

}

SpaceRebEngine::~SpaceRebEngine()
{

}

void SpaceRebEngine::init(int spaceinvader_width,int spaceinvader_height,int missiles_size,int speed)
{
    _spaceinvader_width = spaceinvader_width;
    _spaceinvader_height = spaceinvader_height;
    _missiles_size = missiles_size;
    _speed = speed;
    _player.init(_spaceinvader_height,_spaceinvader_width);  //sets initial values of spaceinvader
    _missiles.init(_missiles_size);  //sets initial values of missilles
    _missiles.set_score();  //sets score of game in missiles.cpp
    _end = false;  //ensures _end = false for each time the game is reset
}

void SpaceRebEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();  //sets _d by takeing the direction from the joystick
    _mag = pad.get_mag();  //sets magnitude by takeing the magnitude from the joystick
}

void SpaceRebEngine::draw(N5110 &lcd)
{
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);  // draw the play area
    _player.draw(lcd);  //draw the spaceinvader
    _missiles.draw(lcd);  // draw the missiles
}

void SpaceRebEngine::update(Gamepad &pad)
{
    _player.update(_d,_mag);  //updates the movement of the spaceinvader
    _missiles.update();  //updates position of missiles
    
    check_spaceinvader_collision(pad);  //checks to see if spaceinvader has been struck by missiles
    check_wall_collision(pad);  //checks to see if missiles has collided with the play area wall
}

void SpaceRebEngine::check_wall_collision(Gamepad &pad)
{   
    Vector2D missiles_pos = _missiles.get_pos();
    Vector2D missiles_velocity = _missiles.get_velocity();
    if (missiles_pos.y <= 1) {  
        missiles_pos.y = 1;  //ensures missiles do not go beyond the y-axis play area at the top
        missiles_velocity.y = -missiles_velocity.y *1.1;  //used to bounce and increase the missiles_velocity.y with each bounce on the wall
        _missiles.add_score();  //incrases score by 1 each time that the missiles hits the wall
        if  (missiles_velocity.y >= 8){
        missiles_velocity.y = 8;  //sets a maximum missiles_velocity.y so missiles dont go 'supersonic'
        }
    } else if (missiles_pos.y + _missiles_size >= (HEIGHT-1) ) { 
        missiles_pos.y = (HEIGHT-1) - _missiles_size;  //ensures missiles do not go beyond the y-axis play area at the bottom
        missiles_velocity.y = -missiles_velocity.y * 1.1;
        _missiles.add_score();
        if  (missiles_velocity.y >= 8){
        missiles_velocity.y = 8;
        }
    } else if (missiles_pos.x + _missiles_size >= (WIDTH-1) ) {
        missiles_pos.x = (WIDTH-1) - _missiles_size;  //ensures missiles do not go beyond the x-axis play area to the right
        missiles_velocity.x = -missiles_velocity.x * 1.1 ; //used to bounce and increase the missiles_velocity.x with each bounce on the wall
        _missiles.add_score();
        if  (missiles_velocity.x >= 8){
        missiles_velocity.x = 8;  //sets a maximum missiles_velocity.x so missiles dont go 'supersonic'
        }
    } else if (missiles_pos.x <= 1) {
        missiles_pos.x = 1;  //ensures missiles do not go beyond the x-axis play area to the left
        missiles_velocity.x = -missiles_velocity.x * 1.1;
        _missiles.add_score();
        if  (missiles_velocity.x >= 8){
        missiles_velocity.x = 8;
        }
    }
    _missiles.set_velocity(missiles_velocity);  //used to set the velocity of the missiles (velocity.y & velocity.x)
    _missiles.set_pos(missiles_pos);  //used to set the position of the missiles (_y & _x)
}

void SpaceRebEngine::check_spaceinvader_collision(Gamepad &pad)
{
    Vector2D missiles_pos = _missiles.get_pos();  //gets the position of missiles
    Vector2D missiles_velocity = _missiles.get_velocity();  //gets the velocity of the missiles
    Vector2D player_pos = _player.get_pos();  //gets the position of the spaceinvader
    if (
        (missiles_pos.y >= player_pos.y) &&
        (missiles_pos.y <= player_pos.y + _spaceinvader_height) && 
        (missiles_pos.x >= player_pos.x) &&
        (missiles_pos.x <= player_pos.x + _spaceinvader_width)  //checks if there is a collision between spaceinvader & missiles
    ) {
        pad.tone(1500.0,0.1);  //beep when spaceinvader collides with missiles
        _end = true;  //sets value to true and does this to end the play mechanic
    }
}

void SpaceRebEngine::print_scores(N5110 &lcd)
{
    _score = _missiles.get_score();  //gets the game score from missiles
    char buffer1[14];
    sprintf(buffer1,"%2d",_score);
    lcd.printString(buffer1,WIDTH - 23,2);  //prints the score on the lcd display
}

bool SpaceRebEngine::game_end()
{
 bool end = _end;
 return end;  //returns boolean value of end which is used to end play mechanic
 }
 