#ifndef SPACEINVADER_H
#define SPACEINVADER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** SpaceInvader class

@brief Class for Spaceinvader

@version 1.0

@author Henri Rigby

@date May 2019

*/

class SpaceInvader
{
public:
    /**constructor*/
    SpaceInvader();
    /**destructor*/
    ~SpaceInvader();
     /** 
    * @brief Sets spaceinvader starting position and speed
    * @param sets position and speed @details Sets starting position and speed of the spaceinvader
    */
    void init(int height,int width);
    /** 
    * @brief Draw the spaceinvader 
    * @return draws spaceinvader @details Uses designed sprite to draw a spaceinvader
    */
    void draw(N5110 &lcd);
    /** 
    * @brief Updates the position of the spaceinvader
    * @param sets position @details Uses movement of joystick to set position of spaceinvader
    */
    void update(Direction d,float mag);
    /** 
    * @brief Gets the position
    * @return position @details returns the position of both the x and y coordinates
    */
    Vector2D get_pos();

private:

    int _height;
    int _width;
    int _x;
    int _y;
    int _speed;

};
#endif