#include "SpaceInvader.h"
SpaceInvader::SpaceInvader()
{

}

SpaceInvader::~SpaceInvader()
{

}
    
void SpaceInvader::init(int height,int width)
{
    _x = WIDTH/2 - width/2 - 2;  //sets x position to be in centre of lcd display
    _y = HEIGHT/2 - height/2 + 1;  //sets y position to be in centre of lcd display
    _height = height;
    _width = width;
    _speed = 1; //sets _speed to equal 1
}

void SpaceInvader::draw(N5110 &lcd)
{
    int invader[8][11] =   {  //sprite for spaceinvader
    { 0,0,1,0,0,0,0,0,1,0,0 },
    { 0,0,0,1,0,0,0,1,0,0,0 },
    { 0,0,1,1,1,1,1,1,1,0,0 },
    { 0,1,1,0,1,1,1,0,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,0,1,1,1,1,1,1,1,0,1 },
    { 1,0,1,0,0,0,0,0,1,0,1 },
    { 0,0,0,1,1,0,1,1,0,0,0 },
};
    lcd.drawSprite(_x,_y,_width,_height,(int *)invader);  //draws spaceinvader sprite
}

void SpaceInvader::update(Direction d,float mag)
{
    _speed = int(mag*7.0f);  //sets _speed to equal 7 * the magnitude of joystick 
    if (d == N) {
        _y-=_speed;  //moves spaceinvader up
    } else if (d == S) {
        _y+=_speed;  //moves spaceinvader down
    } else if (d == W) {
        _x-=_speed;  //moves spaceinvader left
    } else if (d == E) {
        _x+=_speed;  //moves spaceinvader right
    } else if (d == NW) {
        _y-=((2*_speed)^1/2)/2;  //equation prevents spaceinvader strafing when moving diagonally
        _x-=((2*_speed)^1/2)/2;  //moves spaceinvader up and to the left
    } else if (d == SW) {
        _y+=((2*_speed)^1/2)/2;
        _x-=((2*_speed)^1/2)/2;  //moves spaceinvader down and to the left
    } else if (d == NE) {
        _y-=((2*_speed)^1/2)/2;
        _x+=((2*_speed)^1/2)/2;  //moves spaceinvader up and to the right
    } else if (d == SE) {
        _y+=((2*_speed)^1/2)/2;
        _x+=((2*_speed)^1/2)/2;  //moves spaceinvader down and to the right
    }
    if (_x < 1) {
        _x = 1;  //prevents spaceinvader going offscreen to the left
    }
    if (_x > WIDTH - _width - 4) {
        _x = WIDTH - _width - 4;  //prevents spaceinvader going offscreen to the right
    }
    if (_y < 1) {
        _y = 1;  //prevents spaceinvader going offscreen at the top
    }
    if (_y > HEIGHT - _height + 2) {
        _y = HEIGHT - _height + 2;  //prevents spaceinvader going offscreen at the bottom
    }
}

Vector2D SpaceInvader::get_pos() {
    Vector2D p = {_x,_y};  //sets the value of position by taking both x and y coordinates
    return p;    
}