#include "Missiles.h"

Missiles::Missiles()
{

}

Missiles::~Missiles()
{

}

void Missiles::init(int size)
{
    _speed = 3;  // sets initial speed of missile to 3
    _size = size;
    srand(time(NULL));
    int N = rand() % 4;  //randomises a value of N between 0 and 3
    if (N == 0) {
        _y = HEIGHT;  //sets _y value to bottom of lcd display
        _x = rand() % 80 +4;  //randomises _x value
        south();  //calls south function
    } else if (N == 1){
               _y = 0;  //sets _y value to top of lcd display
               _x = rand() % 80 +4;
               north(); //calls north function
    } else if (N == 2){
               _y = rand() % 44 +4;  //randomises _y value
               _x = 0;  //sets _x value to left side of lcd display
               west();  //calls west function
     } else {
            _y = rand() % 44 +4;
            _x = WIDTH;  //sets _x value to right side of lcd display
            east();  //calls east function
    }
}

void Missiles::south()
{
    srand(time(NULL));
    int direction = rand() % 2; //randomises value for direction between 0-1
        if (direction == 0) {
                  _velocity.x = ((2*_speed)^1/2)/2;  //sets x velocity equation means that no strafing will occur
                  _velocity.y = -((2*_speed)^1/2)/2;  //sets y velocity
        } else {
                  _velocity.x = -((2*_speed)^1/2)/2;
                  _velocity.y = -((2*_speed)^1/2)/2;
        }
}

void Missiles::north()
{
           srand(time(NULL));
           int direction = rand() % 2;
            if (direction == 0) {
                       _velocity.x = ((2*_speed)^1/2)/2;
                       _velocity.y = ((2*_speed)^1/2)/2;
            } else {
                    _velocity.x = -((2*_speed)^1/2)/2;
                    _velocity.y = ((2*_speed)^1/2)/2;
            }
}

void Missiles::west()
{
           srand(time(NULL));
           int direction = rand() % 2;
           if (direction == 0) {
                       _velocity.x = ((2*_speed)^1/2)/2;
                       _velocity.y = ((2*_speed)^1/2)/2;
           } else {
                  _velocity.x = ((2*_speed)^1/2)/2;
                  _velocity.y = -((2*_speed)^1/2)/2;
           }
}

void Missiles::east()
{
        int direction = rand() % 2;
        if (direction == 0) {
                   _velocity.x = -((2*_speed)^1/2)/2;
                   _velocity.y = ((2*_speed)^1/2)/2;
        } else {
               _velocity.x = -((2*_speed)^1/2)/2;
               _velocity.y = -((2*_speed)^1/2)/2;
        }
}

void Missiles::update()
{
    _x += _velocity.x;  //sets _x by adding velocity in x direction
    _y += _velocity.y;  //sets _y by adding velocity in y direction
}

void Missiles::draw(N5110 &lcd)
{
    lcd.drawRect(_x,_y,_size,_size,FILL_BLACK);  //draws square representing missile
}

void Missiles::set_velocity(Vector2D v)
{
    _velocity.x = v.x;  //sets the velocity in the x direction
    _velocity.y = v.y;  //sets the velocity in the y direction
}

Vector2D Missiles::get_velocity()
{
    Vector2D v = {_velocity.x,_velocity.y};  //sets 2D velocity
    return v;
}

Vector2D Missiles::get_pos()
{
    Vector2D p = {_x,_y};  //gets the position by taking both _x and _y coordinates
    return p;
}

void Missiles::set_pos(Vector2D p)
{
    _x = p.x;  //sets _x by taking the x component of position
    _y = p.y;  //sets _y by taking the y component of position
}

int Missiles::set_score()
{
    _score = 0;  //sets the value of _score to equal 0
    return _score;
}

void Missiles::add_score()
{
    _score++;  //increases the value of score by 1
}

int Missiles::get_score()
{
    return _score;  //returns the value of _score
}