
#ifndef SPACESHIP_H
#define SPACESHIP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Alien.h"
#include "Bullet.h"




const int spaceship2[32][32]= {
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0},
    {0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0},
    {0,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0},
    {1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1},
    {0,1,1,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,0},
    {0,0,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};



/** Spaceship class
@brief class for spaceship
@version 1.0
@author Laila Al Badwawi
@date April 2019
*/

class Spaceship
{

public:

    

   
    Spaceship();  // constructor
    ~Spaceship();  // destructor  
    /**
    *@brief initialise an identity for the spaceship
    *@param x_spaceship @details the x-cooridante of spaceship in intger
    *@param y_spaceship @details the y-cooridante of spaceship in integer
    *@param speed_spaceship @details the speed of spaceship in integer
     */


    void init(int x_spaceship,int y_spaceship, int speed_spaceship);

    /**
    *@brief drawing the spaceship
    *@param _(N5110 &lcd)@details the libraries which draw the spaceship on the screen.
    */
    void draw(N5110 &lcd);
    /**
    *@brief updating the direction and the magintuide of the spaceship
    *@param_(Direction d,float mag)@details update the direction and the magintuide of the spaceship.
    **/
    void update(Direction d,float mag);
    /**@brief setting up the position the of the spaceship
    *@param _(x,y) @details set the position the of the spaceship in x-cooridante and y-cooridante
    */
    void set_pos(int x, int y);
    /**
    *@brief Gets the postion of the y-cooridante
    *@returns the position of the y-cooridante in integer which refer to the spaceship
     */
    int  get_pos_y();
    /**
    *@brief Gets the postion of the x-cooridante
    *@returns the position of the x-cooridante in integer which refer to the spaceship
    */
    int  get_pos_x();
    /**
    *@brief reading the position of the spaceship
    *@param _(Gamepad and pad)@details the libraries which reading the position of the spaceship in class Spaceship to detect the collisions between it and the other objects.
    */
    void read_input(Gamepad &pad);
    /**
    *@brief adding scores of the spaceship
    *@param _scores @details adding scores when spaceship fired the alien.
    */
    void add_score();
    /**
    *@brief Gets the scores  of the spaceship
    *@returns the number of the scores of the spaceship in integer
    */
    int get_score();


private:

    /**
    *@param (_x_spaceship) a private variable of class Spaceship that represents the x-cooridante of the spaceship
    */
    int _x_spaceship;
    /**
    *@param (_x_spaceship) a private variable of class spaceship that represents the x-cooridante of the spaceship
     */
    int _y_spaceship;

    /**
    *@param (_speed_spaceship) declation of a variable private member which shows the speed of the spaceship.
    */

    int _speed_spaceship;

    /**
    *@param (_spaceship2)a private variable of class Spaceship used for drawing the spaceship in sprite.
    */
    int _spaceship2;
    /**
     *@param  (_score) a private variable of class Spaceship that represent the scores of the spaceship.
    */
    int _score;

    /**
    *@param(_direcation) a private variable of class spaceship that represents the direction of spaceship
    */
    Direction d;
    /**
      *@param(_mag) float a private variable of class spaceship that represents magnitude of the  spaceship
      */
    float mag;
};
#endif