#ifndef SPACEENGINE_H
#define SPACEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Alien.h"
#include "Spaceship.h"
#include "Bullet.h"



/** bullet Class
@brief SpaceEngine controlls the whole game
@author Laila Al Badwawi, University of Leeds
@date April 2019
*/

class SpaceEngine
{

public:

    SpaceEngine();
    ~SpaceEngine();

    /**
    *@brief initialise an identity for the spaceship,alien,bullet
    *@param x_spaceship @details the x-cooridante of spaceship in intger
    *@param y_spaceship @details the y-cooridante of spaceship in integer
    *@param speed_spaceship @details the speed of spaceship in integer
    *@param x_bullet @details the x-cooridante of bullet in intger
    *@param y_bullet @details the y-cooridante of bullet in integer
    *@param speed_bullet @details the speed of bullet in integer
    *@param fired_bullet@details the bullet fired by the spaceship
    *@param x_alien @details the x-cooridante of Alien in intger
    *@param y_alien @details the y-cooridante of Alien in integer
    *@param speed_alien @details the speed of Alien in integer
    */
    void init(int x_spaceship,int y_spaceship, int x_bullet, int y_bullet,int fired_bullet, int x_alien,int y_alien,  int speed_alien, int speed_bullet, int speed_spaceship);
    /**
    *@brief reading the positions of the objects
    *@param _(Gamepad and pad)@details the libraries which reading the the positions of the inputs(objects) in class SpaceEngine to detect the collisions.
    */
    void read_input(Gamepad &pad);
    /**
    *@brief updating the positions of the objects
    *@param_(Gamepad and pad)@details the libraries which updating the the positions of the inputs(objects) in class SpaceEngine to detect the collisions.
    */
    void update(Gamepad &pad);
    /**
    *@brief drawing the objects in the lcd
    *@param _(N5110 &lcd)@details the libraries which drawing the objects of class SpaceEngine on the screen.
    */
    void draw(N5110 &lcd);


private:
    /**
    *@brief checking the objects collision
    *@param _(Gamepad &pad)@details the libraries check the collision betwwen the objects of class SpaceEngine.
    */
    void check_space_collision(Gamepad &pad);
    /**
     * _alien the object of class Alien
    */
    Alien  _alien;
    /**
    * _spaceship the object of class Spaceship
    */
    Spaceship  _spaceship;
    /**
    * _bullet the object of class Bullet
    */
    Bullet  _bullet;
    /*
    *@param (_x_spaceship) a private variable of class Spaceship that represents the x-cooridante of the spaceship
     */
    int _x_spaceship;
    /*
    *@param (_y_spaceship) a private variable of class spaceship that represents the y-cooridante of the spaceship
    */
    int _y_spaceship;
    /*
    *@param (_speed_spaceship) declation of a variable private member which shows the speed of the spaceship.
    */
    int _speed_spaceship;
    /*
    *@param (_x_alien) a private variable of class Alien that represents the x-cooridante of the alien
     */
    int _x_alien;
    /*
    *@param (_y_alien)a private variable of class Alien that represents the y-cooridante of the alien
    */
    int _y_alien;
    /*
    *@param (_speed_alien)a private variable of class Alien that represents the speed of the alien

    */
    int _speed_alien;
    /*
    *@param (_alien_killed)a private variable of class SpaceEngine that represents the killed alien in integer
    */
    int _alien_killed;
    /*@param
    (_fired_bullet)declation of a variable member which shows the fired bullet by the spaceship.
    */
    int _fired_bullet;
    /*@param
     (_x_bullet)declation of a variable member  which shows the x-cooridante of the bullet.
     */
    int _x_bullet;
    /*@param
    (_y_bullet)declation of a variable member  which shows the y-cooridante of the bullet.
    */
    int _y_bullet;
    /*
    *@param (_speed_bullet)a private variable of class Bullet that represents the speed of the bullet.
    */
    int _speed_bullet;

    /*
    *@param (_spaceman)a private variable used for drawing spaceman in the weclcome screen in sprite.
    */
    int _spaceman;
    /*
    *@param (x_alien)a private variable that represents the x-cooridante of the spaceman in integer
    */
    int x_spaceman;
    /*
    *@param (y_alien)a private variable that represents the y-cooridante of the spaceman in integer
    */
    int y_spaceman;
    /*
    *@param (_d)a private variable of class  SpaceEngine that represents the direction of the joystic.
    */
    Direction _d;
    /*
    *@param (_mag)a private variable of class SpaceEngine that represents the magitude of the joystic.
    */
    float _mag;


};

#endif
