#include"SpaceEngine.h"

SpaceEngine::SpaceEngine() //constructor of class SpaceEngine
{
}
SpaceEngine::~SpaceEngine() //Destructor of class SpaceEngine
{
}


// this function to initalise the objects of SpaceEngine class.
void SpaceEngine::init(int x_spaceship,int y_spaceship, int x_bullet, int y_bullet,int fired_bullet, int x_alien,int y_alien, int speed_alien, int speed_bullet, int speed_spaceship)
{
    _x_spaceship=x_spaceship; // represents the x-cooridante of the spaceship.
    _y_spaceship=y_spaceship; // represents the y-cooridante of the spaceship.
    _speed_spaceship=speed_spaceship; // speed of the spaceship.
    _x_bullet=x_bullet;  // represents the x-cooridante of the spaceship.
    _y_bullet=y_bullet;  // represents the y-cooridante of the spaceship.
    _fired_bullet= fired_bullet;  // spaceship fired the alien by relaseing the bullet.
    _x_alien= x_alien;  // represents the x-cooridante of the alien.
    _y_alien= y_alien;  // represents the y-cooridante of the spaceship.
    _speed_alien= speed_alien;  // speed of the alien.
    _speed_bullet=speed_bullet; // speed of the bullet.

    _bullet.init(_x_bullet, _y_bullet, speed_bullet,fired_bullet); // initalise the object bullet.
    _alien.init (_x_alien, _y_alien,_speed_alien);  // initalise the object  alien.
    _spaceship.init( _x_spaceship, _y_spaceship, _speed_spaceship);  // initalise the object  spaceship.
    _alien_killed = 0;  // set the killed alien at 0.
}

// void function for Gamepad library to read the position of the objects.
void SpaceEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}

/**this function draw the objects on the screen
*by using the (N5110 &lcd) libraries
* if statment to check if the alien is alive so the lcd can draw it on the screen
* else if statment will check if the alien dead so it should disappear
*also it draws the spaceship
*/
void  SpaceEngine::draw(N5110 &lcd)
{
    _bullet.draw(lcd);
    if (_alien.isAlive() == true) {
        _alien.draw(lcd);
        // printf("alien is alive\n")
    } else { // alien is dead
        int y_pos = (rand() % 30) + 10; // random number 10 to 39
        _alien.init(70,y_pos,1);  //initalise the alien with its parameters.
        wait(0.2);//wait 0.2 sec
    }
    _spaceship.draw(lcd);
    lcd.printString("alien_killed",0,0);
    char kills[14];
    sprintf(kills,"%2d",_alien_killed);
    lcd.printString(kills,70,0);
}

/*
*this void function for reading the the positions of the inputs(objects)by(Gamepad &pad)libraries in class SpaceEngine to detect the collisions.
*this inculde if statment that shows when joystic's direction to the east the bullt will be fired.
*/
void SpaceEngine::update(Gamepad &pad)
{
    _bullet.update(_d,_mag);
    _alien.update(_d,_mag);
    _spaceship.update(_d,_mag);
    check_space_collision(pad);
    _y_alien = _alien.get_pos_y();
    _x_alien = _alien.get_pos_x();
    _y_bullet = _bullet.get_pos_y();
    _x_bullet = _bullet.get_pos_x();
    if(_d==E) {
        _fired_bullet=1;
        pad.tone(1000.0,0.1);
        // printf("bullet fired alien\n")
        _bullet.set_pos(_spaceship.get_pos_x()+33, _spaceship.get_pos_y());
    }
}

/*void function that checks the collision between the objects
*if statment is to detect if x-coordinate of the bullet is larger or equal 65
*and less than or equal to the 68 and if y-cooridante of the bullet is larger
*than y-corrdindate of the alien-5 and y_alien+15 is larger or equal y_bullet
*then the alien gets killed.
*/
void SpaceEngine::check_space_collision(Gamepad &pad)
{
    if(_x_bullet >= 65 && _x_bullet <= 68 && _y_bullet >= _y_alien-5 && _y_bullet <= _y_alien+15) {
        _alien.setAlive(false);
        // printf("alive alien false\n")
        _alien_killed++;
        // printf(" killed alien incremebt by 1\n")
    }
}