
#ifndef BULLET_H
#define BULLET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"




const int bullet2[16][16] =   {
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0},
};



/** bullet Class
@brief Controls the bullet in the SpaceInvaders game
@author Laila Al Badwawi, University of Leeds
@date April 2019
*/

class Bullet
{

public:

    /**
    *@constucter creat a defult bullet
    */
    Bullet();
    /*@destucter creat a defult bullet
    */
    ~Bullet();

  

    /**
       *@brief initialise an identity for the Bullet
       *@param x_bullet @details the x-cooridante of bullet in intger
       *@param y_bullet @details the y-cooridante of bullet in integer
       *@param speed_bullet @details the speed of bullet in integer
       *@param fired_bullet@details the bullet fired by the spaceship
       */

    void init(int x_bullet,int y_bullet, int speed_bullet, int fired_bullet);
     /**
    *@brief drawing the bullet in the lcd 
    *@param _(N5110 &lcd)@details the libraries which draw the bullet.
    */

    void draw(N5110 &lcd);
    /**
    *@brief updating the direction and the magintuide of the bullet
    *@param_(Direction d,float mag)@details update the direction and the magintuide of the bullet.
    **/
    void update(Direction d,float mag);
    /**@brief setting up the position the of the bullet
    *@param _(x,y) @details set the position the of the bullet in x-cooridante and y-cooridante
    */
    void set_pos(int x, int y);
    
    /**Gets the postion of the y-cooridante 
    *@returns the position of the y-cooridante which refer to the bullet
    */
    int get_pos_y();
   /**Gets the postion of the x-cooridante 
    @returns the position of the x-cooridante which refer to the bullet
    */
    int get_pos_x();

private:
//member variables
//parameters

    /**
     *@param(_x_bullet)declation of a variable member  which shows the x-cooridante of the bullet.
     */
    int _x_bullet;
    /**
    *@param(_y_bullet)declation of a variable member  which shows the y-cooridante of the bullet.
    */
    int _y_bullet;
   /**
    *@param(_fired_bullet)declation of a variable member which shows the fired bullet by the spaceship.
    */
    int  _fired_bullet;
   /**
    *@param (_speed_bullet)a private variable of class Bullet that represents the speed of the bullet.    
    */
    int _speed_bullet;
    /**
    *@param (_bullet2)a private variable of class Bullet used for drawing bullet in sprite.    
    */
    int _bullet2;

    /**
    *@param(_direcation) a private variable of class  that represents of bullet
    */
    Direction d;
    /**
    *@param(_mag) float a private variable of class Bullet that represents magnitude of the  bullet
       */
    float mag;

};
#endif