#ifndef Alien_H
#define Alien_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"


const int alien2[32][32]= {


    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0},
    {0,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,1,0,0,0,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,0,0,0,1,1,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};

/** Alien class
@brief class for Alien
@version 1.0
@author Laila Al Badwawi
@date April 2019
*/
class Alien
{
public:
    Alien();  // constructor
    ~Alien(); // destructor

    /**
      *@brief initialise an identity for the Alien
      *@param x_alien @details the x-cooridante of Alien in intger
      *@param y_alien @details the y-cooridante of Alien in integer
      *@param speed_alien @details the speed of Alien in integer
      */

    void init(int x_alien,int y_alien, int speed_alien);
    /**
    *@brief drawing the alien in the lcd
    *@param _(N5110 &lcd)@details the libraries which draw the alien in class Alien.
    */
    void draw(N5110 &lcd);
    /**
    *@brief updating the direction and the magintuide of the alien
    *@param_(Direction d,float mag)@details update the direction and the magintuide of the alien.
    **/
    void update(Direction d,float mag);

    /**@brief sitting up the position the of the alien
    *@param _(x,y) @details set the position the of the alien in x-cooridante and y-cooridante
    */
    void set_pos(int x, int y);
    /**@brief Gets the postion of the y-cooridante
       *@returns the position of the y-cooridante in integer which refer to the alien
       */
    int  get_pos_y();
    /**@brief Gets the postion of the x-cooridante
    *@returns the position of the x-cooridante in integer which refer to the alien
    */
    int  get_pos_x();
    /**
    *@brief adding scores of the Alien
    *@param _scores @details adding scores when alien fired the spaceship back.
    */
    void add_score();
    /**@brief Gets the scores  of the Alien
    *@returns the number of the scores of the alien in integer
    */
    int get_score();
    /**
    *@brief reading the position of the alien
    *@param _(Gamepad and pad)@details the libraries which reading the position of the alien in class Alien to detect the collisions between it and the other objects.
    */
    void read_input(Gamepad &pad);
    /**@brief Gets the alive Alien
    *@returns alive alien in bool
    */
    bool isAlive();
    /**@brief sitting the alive Alien
    *@param alive @details set the positions of the alive alien in class Alien
    */
    void setAlive(bool alive);


private:
   

    /**
    *@param (_x_alien) a private variable of class Alien that represents the x-cooridante of the alien
     */
    int _x_alien;

    /**
    *@param (_y_alien)a private variable of class Alien that represents the y-cooridante of the alien
    */

    int _y_alien;
    /**
    *@param (_alien2)a private variable of class Alien used for drawing the alien in sprite.
    */
    int _alien2;
    /**
    *@param (_speed_alien)a private variable of class Alien that represents the speed of the alien

    */
    int _speed_alien;

    /**
     *@param  (_score) a private variable of class Alien that represent the scores was achived by alien
    */
    int _score;

    /**
     @param(_alive)  a private variable of class Alien that represents the Alive alien
     */
    bool _alive;

    /**
    *@param(_direcation) a private variable of class Alien that represents the direction of the alien
    */
    Direction d;

    /**
     *@param(_mag) float a private variable of class Alien that represents magnitude of the  alien
     */
    float mag;
};
#endif