///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Engine.h"


#define BALL_SIZE 4
#define BALL_SPEED 3
#define PADDLE_HEIGHT 4
#define PADDLE_WIDTH 12
#define BLOCK_SIZE 8

/////////////// structs /////////////////
struct UserInput 
{
    Direction d;
};

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Engine engine;


///////////// prototypes ///////////////
void init();
void display();
void start();


///////////// functions ////////////////
int main()
{
   
   
   int fps = 6; // frames per second
   
   init(); // initialise
   start(); // display the welcome screen and wait for starting
   
   
   display(); // draw the initial frame
   wait(1.0f/fps); 
   
   // game loop
   while  (1) {
        engine.read_input(pad);
        engine.update(lcd,pad);
        display();
        wait(1.0f/fps);
    }
}

// initial all classea and libraries 
void init()
{
    // initialise lcd and gamepad
    lcd.init();
    pad.init();
    
    // initialise the game content
    engine.init(PADDLE_WIDTH,PADDLE_HEIGHT,BALL_SIZE,BALL_SPEED,BLOCK_SIZE);
    
}

//draw frame on the lcd
void display()
{
    // clear the screen
    lcd.clear();
    //draw the content
    engine.draw(lcd);
    //refresh
    lcd.refresh();
}

// start screen 
void start()
{
    // print the name of game 
    lcd.printString("   *PINBALL*",0,1);
    lcd.printString("   -",0,3);
    wait(0.3);
    lcd.printString("   --",0,3);
    wait(0.3);
    lcd.printString("   ---",0,3);
    wait(0.3);
    lcd.printString("   ----",0,3);
    wait(0.3);
    lcd.printString("   -----",0,3);
    wait(0.3);
    lcd.printString("   -----Sihui Fu",0,3);
    wait(0.3);
    lcd.printString("Press to Start~",0,4);
    lcd.refresh();
    
    //wait for the start button to be pressed
    while (pad.check_event(Gamepad::START_PRESSED) == false)
    {
        pad.leds_on();
        wait(0.3);
        pad.leds_off();
        wait(0.3);
    }
}
    
    
