#ifndef PADDLE_H
#define PADDLE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Paddle Class
@author Sihui Fu
@brief Controls the paddle in the pinball game 
@date April 2019
*/ 
class Paddle
{

    public:
    
        Paddle();
        ~Paddle();
        void init(int height, int width);
        void draw(N5110 &lcd);
        void update(Direction d);
        Vector2D get_position();
        
    private:
    
        int _height;
        int _width;
        int _x;
        int _y;
        int _speed;
        
        
};

#endif