#ifndef PONGENGINE_H
#define PONGENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ball.h"
#include "Paddle.h"
#include "Block.h"


class Engine
{
    
    public:
    
        Engine();
        ~Engine();
        
        void init(int paddle_width,int paddle_height,int ball_size,int speed, int block_size);
        void draw(N5110 &lcd);
        void update(N5110 &lcd, Gamepad &pad);
        void read_input(Gamepad &pad);
        
    private:
    
        void check_wall_collision(Gamepad &pad);
        void check_paddle_collision(Gamepad &pad);
        void check_block_collision(Gamepad &pad);
        void game_over(N5110 &lcd, Gamepad &pad);
        void draw_scores(N5110 &lcd);
    
        Paddle _paddle;
        
        int _paddle_width;
        int _paddle_height;
        int _ball_size;
        int _speed;
        
        Ball _ball;
        
        Direction _d;
        
        Block _block;
        int _block_size;
        
};

#endif
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        