#include "Engine.h"


Engine::Engine()
{

}

Engine::~Engine()
{

}

void Engine::init(int paddle_width,int paddle_height,int ball_size,int speed, int block_size)
{
    // initialise the game parameters
    _paddle_width = paddle_width;
    _paddle_height = paddle_height;
    _ball_size = ball_size;
    _speed = speed;
    _block_size = block_size;
    
    // put paddle and ball in middle
    _paddle.init(_paddle_height,_paddle_width);
    _ball.init(_ball_size,_speed);
    _block.init(_block_size);
    
}

// draw the elements in the LCD buffer 
void Engine::draw(N5110 &lcd)
{
    //pitch
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    //paddle
    _paddle.draw(lcd);
    //ball
    _ball.draw(lcd);
    //block
    _block.draw(lcd);
}

void Engine::update(N5110 &lcd, Gamepad &pad)
{
    
    _paddle.update(_d);
    _ball.update();
    
    check_wall_collision(pad);
    check_paddle_collision(pad);
    
    check_block_collision(pad);
    
    game_over(lcd,pad);
    draw_scores(lcd);
}

void Engine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    
}

void Engine::check_wall_collision(Gamepad &pad)
{
    //read current ball attributes
    Vector2D ball_position = _ball.get_position();
    Vector2D ball_speed = _ball.get_speed();
    
    //check if hit the top wall
    if (ball_position.y <= 1)
    {
        ball_position.y = 1;
        ball_speed.y = -ball_speed.y;
        
    } 
    // check if hit left wall
    if (ball_position.x <= 1)
    {
        ball_position.x = 1;
        ball_speed.x = -ball_speed.x;
        
    }
    // check if hit right wall
    else if (ball_position.x + _ball_size/2 >= (WIDTH - 1))
    {
        ball_position.x = (WIDTH - 1) - _ball_size/2;
        ball_speed.x = -ball_speed.x;
        
    }
    
    //update ball parameters
    _ball.set_position(ball_position);
    _ball.set_speed(ball_speed);
}

void Engine::check_paddle_collision(Gamepad &pad)
{
    //read current ball attributes
    Vector2D ball_position = _ball.get_position();
    Vector2D ball_speed = _ball.get_speed();
    
    //read paddle position
    Vector2D paddle_position = _paddle.get_position();
    
    if  ( (ball_position.x >= paddle_position.x) &&
          (ball_position.x <= paddle_position.x + _paddle_width) &&
          (ball_position.y + _ball_size/2 >= paddle_position.y) &&
          (ball_position.y + _ball_size/2 <= paddle_position.y + _paddle_height)
    )  {
          ball_position.y = paddle_position.y - _ball_size/2;
          ball_speed.y = -ball_speed.y;
          
    }
    
    //update new attributes
    _ball.set_position(ball_position);
    _ball.set_speed(ball_speed);
    
}

void Engine::check_block_collision(Gamepad &pad)
{
    //read current ball attributes
    Vector2D ball_position = _ball.get_position();
    Vector2D ball_speed = _ball.get_speed();
    // read current block position
    Vector2D block_position = _block.get_position();
    
    //check if hit the top
    if ((ball_position.x >= block_position.x) &&
        (ball_position.x <= block_position.x + _block_size) &&
        (ball_position.y + _ball_size/2 >= block_position.y) &&
        (ball_position.y + _ball_size/2 <= block_position.y + _block_size)
    ) {
        ball_speed.y = -ball_speed.y;
        _block.add_score(); // once established, score
        pad.tone(750.0,0.1); // audio feedback
        _block.get_block(); // create a new block in random position
        pad.leds_on(); 
        wait(0.1);
        pad.leds_off();
    }
    //check if hit the bottom 
    if ((ball_position.x >= block_position.x) &&
        (ball_position.x <= block_position.x + _block_size) &&
        (ball_position.y - _ball_size/2 >= block_position.y) &&
        (ball_position.y - _ball_size/2 <= block_position.y + _block_size)
    ) {
        ball_speed.y = -ball_speed.y;
        _block.add_score(); // once established, score
        pad.tone(750.0,0.1); // audio feedback
        _block.get_block(); // create a new block in random position
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
    }
    //check if hit the left
    if ((ball_position.y >= block_position.y) &&
        (ball_position.y <= block_position.y + _block_size) &&
        (ball_position.x + _ball_size/2 >= block_position.x) &&
        (ball_position.x + _ball_size/2 <= block_position.x + _block_size)
    ) {
        ball_speed.x = -ball_speed.x;
        _block.add_score(); // once established, score
        pad.tone(750.0,0.1); // audio feedback
        _block.get_block(); // create a new block in random position
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
    }
    //check if hit the right
    if ((ball_position.y >= block_position.y) &&
        (ball_position.y <= block_position.y +_block_size) &&
        (ball_position.x - _ball_size/2 >= block_position.x) &&
        (ball_position.x - _ball_size/2 <= block_position.x +_block_size)
    ) {
        ball_speed.x = -ball_speed.x;
        _block.add_score(); // once established, score
        pad.tone(750.0,0.1); // audio feedback
        _block.get_block(); // create a new block in random position
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
    }
    
    //update new attributes
    _ball.set_position(ball_position);
    _ball.set_speed(ball_speed);
}

void Engine::game_over(N5110 &lcd,Gamepad &pad)
{
    // get the position
    Vector2D ball_position = _ball.get_position();
    Vector2D paddle_position = _paddle.get_position();
    // get the current score
    int _score = _block.get_score();
    
    // determine if the game is over
    while (ball_position.y > paddle_position.y + _paddle_height)
    {
        lcd.clear();
        lcd.printString("Game Over!",0,1); // print to the screen
        lcd.printString("The Score is :",0,2);
        char buffer1[14];
        sprintf(buffer1,"%2d",_score);
        lcd.printString(buffer1,30,3);
        lcd.printString("Press Reset",0,4);
        lcd.printString("To Reset",0,5);
        lcd.refresh();
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1); 
        init(_paddle_width,_paddle_height,_ball_size,_speed,_block_size);
    }
    
}

void Engine::draw_scores(N5110 &lcd)
{
    int _score = _block.get_score();
    
    char buffer[14];
    sprintf(buffer,"%2d",_score);
    lcd.printString(buffer,25,0);

}
    