#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Ball Class
@author Sihui Fu
@brief Controls the Ball in the pinball game 
@date April 2019
*/ 

class Ball
{
    
public:

    Ball();
    ~Ball();
    void init(int size, int speed);
    void draw(N5110 &lcd);
    void update();
    
    //accessors
    void set_speed(Vector2D speed);
    void set_position(Vector2D position);
    
    //mutators
    Vector2D get_speed();
    Vector2D get_position();
    

private:
        
    int _size;
    int _x;
    int _y;
    int _radius;
    Vector2D _speed;
 
};
#endif