#include "Ball.h"

Ball::Ball()
{
    
}

Ball::~Ball()
{
    
}

void Ball::init(int size, int speed)
{
    _size = size;
    
    _x = WIDTH/2 - _size/2;
    _y = HEIGHT/2 - _size/2;
    
    _radius = _size/2;
    
    // let the ball be fired randomly in one direction
    srand(time(NULL));
    int direction = rand() % 4;
    // 4 possiblities
    if (direction == 0) {
        _speed.x = speed;
        _speed.y = speed;
    } else if (direction == 1) {
        _speed.x = speed;
        _speed.y = -speed;
    } else if (direction == 2) {
        _speed.x = speed;
        _speed.y = speed;
    } else {
        _speed.x = -speed;
        _speed.y = -speed;
    }
    
    
}

// draw pinball
void Ball::draw(N5110 &lcd)
{
    lcd.drawCircle(_x,_y,_radius,FILL_TRANSPARENT);
}

void Ball::update()
{
    _x += _speed.x;
    _y += _speed.y;
}

void Ball::set_speed(Vector2D speed)
{
    _speed.x = speed.x;
    _speed.y = speed.y;
}

Vector2D Ball::get_speed()
{
    Vector2D speed = {_speed.x,_speed.y};
    return speed;
}

void Ball::set_position(Vector2D position)
{
    _x = position.x;
    _y = position.y;
}

Vector2D Ball::get_position()
{
    Vector2D position = {_x,_y};
    return position;
}




