/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: ZHENWEN LIAO
Username: Zhenwewn liao
Student ID Number: 201179455
Date: March 05 2019
*/

/*
Final version! Sokoban game with 3 level and a short introduction. 
Use the joystick to select from menu and enter each level. 
Use bottom A,B,X,Y to play the game,and tone can be adjusted by the potentialmeter.
Enjoy!
*/
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "PushingEngine.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
PushingEngine push;

int score = 0;
Vector2D joy_input = {0,0};

///////////// prototypes ///////////////
void init();
void welcome();
void print_scores(N5110 &lcd);
void game();
int level_selecting(int level,int confirm);
int entering_level(N5110 &lcd,Gamepad &pad);
void runing_diff_level(N5110 &lcd,Gamepad &pad,PushingEngine &push,int current_level);
void winning_tone(Gamepad &pad);

///////////// functions ////////////////
int main()
{
    init();     // initialise and then display welcome screen...
    welcome();  // waiting for the user to start

    while(1) {
        int confirmed_level = entering_level(lcd,pad);
        runing_diff_level(lcd,pad,push,confirmed_level);
        wait(0.5);
    }
}

void init()
{
    // need to initialise LCD and Gamepad
    lcd.init();
    pad.init();

    // initialise the game with level-1 position of boxes,cross and ppl
    push.init(34,20,42,28,42,20,34,12,50,28,0,1);
}

void welcome()
{
    lcd.printString("    Sokoban    ",1,1);
    lcd.printString("  Press Start",0,4);
    lcd.refresh();

    // wait flashing LEDs until start button is pressed
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        for (int i=1; i<7; i++) {
            pad.led(i,1);
            wait(0.1);
            pad.led(i,0);}
    }
}

void game() // runing the game and get the score
{
    lcd.clear();
    push.read_input(pad);
    push.update(pad,34,28);
    push.draw(lcd,34,28);
    lcd.refresh();
    wait(0.6);
    push.reset_menu();
    score = push.set_score();
}

void print_scores(N5110 &lcd) // print the pause screen and score 
{
    lcd.clear();
    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",score);
    lcd.printString(buffer1,32,2);

    lcd.printString("    Pause!    ",1,0);
    lcd.printString("Your score is:",1,1);
    lcd.printString("  Press BACK ",1,4);
    lcd.printString("  Go to Menu",1,5);
    lcd.refresh();
    while( pad.check_event(Gamepad::BACK_PRESSED) == false) {
          pad.leds_bus(1,1,1,0,0,0);
          wait(0.3);
          pad.leds_bus(0,0,0,1,1,1);
          wait(0.3);
    }
    pad.leds_bus(0,0,0,0,0,0);
}

int level_selecting(int level,int confirm) // confirming the level selected
{
    int selected_level = 0; // print the menu
    if(level == 0 && confirm == 1) {
        selected_level = 1; //  run the 1st game
    }
    if(level == 1 && confirm == 1) {
        selected_level = 2; // run the 2nd game
    }
    if(level == 2 && confirm == 1) {
        selected_level= 3; // run the 3rd game
    }
    if(level == 3 && confirm == 1) {
        selected_level = 4; // restart
    }
    return selected_level;
}

int entering_level(N5110 &lcd,Gamepad &pad)  // enter the level with the reading of joystick
{
    Vector2D joy_input = push.get_menu(lcd,pad);
    int level = joy_input.x;
    int level_confirm = joy_input.y;
    printf("The level is %d The key is %d\n",level,level_confirm);
    int confirmed_level = level_selecting(level,level_confirm); // 0 : Menu; 1: level 1; 2:level 2; 3: level 3; 4 : Restart
    printf("The move is %d\n",confirmed_level);
    return confirmed_level;
}

void winning_tone(Gamepad &pad) // winning tone if scores 2
{
    pad.tone(1500.0,0.1); wait(0.2);
    pad.tone(1700.0,0.1); wait(0.2);
    pad.tone(1400.0,0.1); wait(0.2);
    pad.tone(1000.0,0.1); wait(0.2);
    pad.tone(900.0,0.1); wait(0.2);
    pad.tone(800.0,0.1); wait(0.2);
}

void runing_diff_level(N5110 &lcd,Gamepad &pad,PushingEngine &push,int current_level) // the loop of the different level of game or printing the Menu
{
    switch(current_level) {
        
    // Menu   
        case 0 : 
            lcd.clear();
            push.get_menu(lcd,pad);
            break;
            
    // Game level 1
        case 1 : // Game level 1
            push.init(34,20,42,28,42,20,34,12,50,28,0,1);
            while(1) {
                game();
                if (score == 2|| pad.check_event(Gamepad::BACK_PRESSED) == true ) {
                    if(score == 2) { winning_tone(pad); } // play winning tone
                    print_scores(lcd);
                    break; // break the pausing loop 
                } 
            } break;
            
    // Game level 2
        case 2 : 
            push.init(26,20,34,20,42,20,42,12,42,28,1,1);
            while(1) {
                game();
                if (score == 2|| pad.check_event(Gamepad::BACK_PRESSED) == true ) {
                    if(score == 2) {winning_tone(pad);} // play winning tone
                    print_scores(lcd);
                    break;  // break the pausing loop 
                }
                //if (pad.check_event(Gamepad::BACK_PRESSED) == true) {;}
            } break;
            
     // Game level 3
        case 3:
            push.init(34,12,26,28,26,12,42,12,42,28,2,1);
            while(1) {
                game();
                if (score == 2 || pad.check_event(Gamepad::BACK_PRESSED) == true) {
                    if(score == 2) {winning_tone(pad);}  // play winning tone
                    print_scores(lcd);
                    break; // break the pausing loop
                } 
                if (pad.check_event(Gamepad::BACK_PRESSED) == true) {;}
            } break;
            
     // A short introduchtion to the game
        case 4:
            push.introduction(lcd,pad);
            wait(3);lcd.clear();
            lcd.printString("    ENJOY!    ",0,3);
            lcd.refresh();
            wait(3);
            break;
     }
}