#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Ppl Class
@author Zhenwen liao, University of Leeds
@brief Controls the Ppl in the Sokoban game
@date 04 2019
*/
class Ppl
{

public:
    /** Constructor */
    Ppl();

    /** Destructor */
    ~Ppl();

    /** Initialise the first position of ppl
    * @param x0 @details the first x position of ppl (int)
    * @param y0 @details the first y position of ppl (int)
    */
    void init(int x0, int y0);

    /** Draw the Ppl accroading to the current _x,_y
    * @param lcd @details the object of screen
    */
    void draw(N5110 &lcd);


    /** Update the reading of box parameter
    * @param bb @details the indicater of botton B being push or not (int)
    * @param ba @details the indicater of botton A being push or not (int)
    * @param bx @details the indicater of botton X being push or not (int)
    * @param by @details the indicater of botton Y being push or not (int)
    * @param indicator @details indicator for function hold_ppl_box_touching (int)
    * @param barrier_x @details the x position of barrier (int)
    * @param barrier_y @details the y position of barrier (int)
    */
    void update(int bb,int ba,int bx,int by,int indicator,int barrier_x,int barrier_y);

    /**
     * @brief Check whether after moving if ppl pos match the barrier
     * @param barrier_x @details the x position of barrier (int)
     * @param barrier_y @details the y position of barrier (int)
     * @return true if matched barrier atfer next move
     */
    bool hold_beside_barrier(int barrier_x,int barrier_y);

    /** Move the ppl with respect to the bottom read
    * @param bb @details the indicater of botton B being push or not (int)
    * @param ba @details the indicater of botton A being push or not (int)
    * @param bx @details the indicater of botton X being push or not (int)
    * @param by @details the indicater of botton Y being push or not (int)
    */
    void move_ppl(int bb,int ba,int bx,int by);

    /**
     * @brief Check whether box facing wall and hold pos of ppl
     * @param indicator @details indicating the respected position of Ppl and Box (int)
     * @details   0: do nothing
     *            1: next move box off the left hold ppl in x = 10;
     *            2: next move box off the right  hold ppl in x = 66;
     *            3: next move box off the top  hold ppl in y = 12;
     *            4: next move box off the bottom hold ppl in y = 28;
     */
    void hold_ppl_box_touching(int indicator);
    
    /** Hold the position if ppl go off screen */
    void hold_ppl_against_wall();

    /** get the current position of ppl */
    Vector2D get_pos();

    /** set the position of ppl
    * @param p @details the Vector form of ppl (Vector2D)
    */
    void set_pos(Vector2D p);



private:
    // position of the ppl
    int _x;
    int _y;
};