#include "Ppl.h"

const int ppl[8][8]= {
    {0,0,0,0,1,1,1,0},
    {0,0,0,0,1,0,1,0},
    {0,0,0,0,1,1,1,0},
    {1,0,0,0,0,1,0,0},
    {0,1,1,0,0,1,0,0},
    {0,0,0,1,1,1,0,0},
    {0,0,0,0,0,1,0,0},
    {0,0,0,1,1,0,1,1},

};

Ppl::Ppl()
{

}

Ppl::~Ppl()
{

}

void Ppl::init(int x0, int y0)
{
    _x = x0;
    _y = y0;

}

void Ppl::draw(N5110 &lcd)
{
    lcd.drawSprite(_x,_y,8,8,(int *)ppl);
}

void Ppl::update(int bb,int ba,int bx,int by,int indicator,
                 int barrier_x,int barrier_y)
{
    int temp_x = _x;
    int temp_y = _y;

    move_ppl(bb,ba,bx,by);

    if (hold_beside_barrier(barrier_x,barrier_y)) {
        _x = temp_x;
        _y = temp_y;
    } else {
        _x = _x;
        _y = _y;
    }
    
    hold_ppl_against_wall();
    hold_ppl_box_touching(indicator);

}

Vector2D Ppl::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}

void Ppl::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}

bool Ppl::hold_beside_barrier(int barrier_x,int barrier_y) // check after moving if ppl pos match the barrier
{
    // if matched barrier return ture
    if (_x == barrier_x &&_y == barrier_y) {
        return true;
    } else {
        return false;
    }
}

void Ppl::move_ppl(int bb,int ba,int bx,int by) //move the ppl with respect to the bottom read
{

    if (bx ==0 && bb == 0 && by == 0 && ba == 0) {
        _x = _x;
        _y = _y;
    }
    if (bx == 1) {
        _x = _x-8;
        _y = _y;
    }
    if (bb == 1) {
        _x = _x+8;
        _y = _y;
    }
    if (by == 1) {
        _y = _y-8;
        _x = _x;
    }
    if (ba == 1) {
        _y = _y+8;
        _x = _x;
    }
}

void Ppl::hold_ppl_box_touching(int indicator) //check for box facing wall and hold pos of ppl
// 0: do nothing
// 1: next move box off the left hold ppl in x = 10; 2: next move box off the right  hold ppl in x = 66;
// 3: next move box off the top  hold ppl in y = 12; 4: next move box off the bottom hold ppl in y = 28;
{
    if (indicator == 0 ) {
        _y = _y;
        _x = _x;
    } else if (indicator == 1 && _x <=10) {
        _x = 10;
    } else if (indicator == 2 && _x >=66) {
        _x = 66;
    } else if (indicator == 3 && _y <=12 ) {
        _y = 12;
    } else if (indicator == 4 && _y >=28) {
        _y = 28;
    } 
}

void Ppl::hold_ppl_against_wall() // check the y origin to ensure that the paddle doesn't go off screen
{
    if (_y < 4) {
        _y = 4;
    }
    if (_y > 36) {
        _y = 36;
    }
    if (_x > 74) {
        _x = 74;
    }
    if (_x < 2) {
        _x = 2;
    }
}