#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Menu Class
@author Zhenwen liao, University of Leeds
@brief Controls the Menu in the Sokoban game 
@date 04 2019
*/ 
class Menu
{

public:
    /** Constructor */
    Menu();
    
    /** Destructor */
    ~Menu();
    
    /** Initialise the Menu readings
    * @param bj @details the position of the joystick move (int)
    * @param bjoy @details whether the joystick is push or not (int)
    */
    void init(int bj,int bjoy);
    
    /** Print the Menu accroding to the readin of the position of joystick*/
    void print(N5110 &lcd,Gamepad &pad);
    
    /** Update the parameter of the joystick with the input of it
    */
    void update(Gamepad &pad);
    
    /** Get the current level and confirmation of level */
    Vector2D get_level();
    
    /** Set the current level and confirmation of level 
    * @param p @details p = {level,confirmation}
    * @details confirmation: 0 means not confirm; 1 means confirm;
    */
    void set_level(Vector2D p);
    
private:
    int _x;
    int _y;
};
