#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Box Class
*@author Zhenwen liao, University of Leeds
*@brief Controls the Box in the Sokoban game
*@date April 2019
*/
class Box
{

public:
    /** Constructor */
    Box();

    /** Destructor */
    ~Box();

    /** Initialise the first position of box
    * @param x0 @details the first x position of box (int)
    * @param y0 @details the first y position of box (int)
    */
    void init(int x0, int y0);
    
    /** Draw the box accroading to the current _x,_y
    * @param lcd @details the object of screen 
    */
    void draw(N5110 &lcd);
    
    /** Update the reading of box parameter
    * @param s @details the indicater of which direction can be push to (int)
    * @param bb @details the indicater of botton B being push or not (int)
    * @param ba @details the indicater of botton A being push or not (int)
    * @param bx @details the indicater of botton X being push or not (int)
    * @param by @details the indicater of botton Y being push or not (int)
    * @param barrier_x @details the x position of barrier (int)
    * @param barrier_y @details the y position of barrier (int)
    */
    void update(int s,int bb,int ba,int bx,int by,int barrier_x,int barrier_y);
    
    /** Move the box accroading to the pos of ppl and reading of bottom
    * @param s @details the position of the ppl with respect to the box (int)
    * @param bb @details the indicater of botton B being push or not (int)
    * @param ba @details the indicater of botton A being push or not (int)
    * @param bx @details the indicater of botton X being push or not (int)
    * @param by @details the indicater of botton Y being push or not (int)
    */
    void move_box(int s,int bb,int ba,int bx,int by);
    
    /** hold the box if next move off the screen */
    void hold_box_against_wall();
    
    /** get the current position of box */
    Vector2D get_pos();
    
    /** set the position of box 
    * @param p @details the Vector form of box (Vector2D)
    */
    void set_pos(Vector2D p);

private:

    // position of box
    int _x;
    int _y;
};
