#include "PushingEngine.h"


const int barrier[8][8]= {
    {1,1,1,1,1,1,1,1},
    {1,1,0,0,0,0,1,1},
    {1,0,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,1},
    {1,1,0,0,0,0,1,1},
    {1,1,1,1,1,1,1,1},
};



PushingEngine::PushingEngine()
{

}

PushingEngine::~PushingEngine()
{

}

void PushingEngine::init(int box1_x,int box1_y,int box2_x,int box2_y,
                         int ppl_x,int ppl_y,
                         int cross1_x,int cross1_y,int cross2_x,int cross2_y,
                         int menu_x,int menu_y)
{
    // boxes position on screen
    _b1x = box1_x;
    _b2x = box2_x;
    _b1y = box1_y;
    _b2y = box2_y;

    // ppl position on screen
    _pplx = ppl_x;
    _pply = ppl_y;

    // crosses position on screen
    _c1x = cross1_x;
    _c1y = cross1_y;
    _c2x = cross2_x;
    _c2y = cross2_y;

    // menu parameter
    _bj = menu_x;
    _bjoy = menu_y;


    // inital Boxes, Crosses, Ppl and Menu
    _b1.init(_b1x,_b1y);
    _b2.init(_b2x,_b2y);
    _ppl.init(_pplx,_pply);
    _c1.init(_c1x,_c1y);
    _c2.init(_c2x,_c2y);
    _menu.init(_bj,_bjoy);

}

void PushingEngine::read_input(Gamepad &pad)
{
    float pot = pad.read_pot();        // reading of the potentialmeter
    if (pad.check_event(Gamepad::A_PRESSED)) {
        _ba = 1;
        pad.tone(3000*pot,0.1);
    } else {
        _ba = 0;
    }
    if (pad.check_event(Gamepad::B_PRESSED)) {
        _bb = 1;
        pad.tone(3000*pot,0.1);
    } else {
        _bb = 0;
    }
    if (pad.check_event(Gamepad::X_PRESSED)) {
        _bx = 1;
        pad.tone(3000*pot,0.1);
    } else {
        _bx = 0;
    }
    if (pad.check_event(Gamepad::Y_PRESSED)) {
        _by = 1;
        pad.tone(3000*pot,0.1);
    } else {
        _by = 0;
    }
}

void PushingEngine::update(Gamepad &pad,int barrier_x,int barrier_y)
{
    check_ppl_box1_touching(pad);
    check_ppl_box2_touching(pad);

    hold_ppl_box1_wall(pad);
    hold_ppl_box2_wall(pad);

    Vector2D temp_ppl_pos = _ppl.get_pos();
    _b1.update(_s,_bb,_ba,_bx,_by,barrier_x,barrier_y);
    _b2.update(_r,_bb,_ba,_bx,_by,barrier_x,barrier_y);
    _ppl.update(_bb,_ba,_bx,_by,_temp,barrier_x,barrier_y);
    // reset all the indicator to 0 every time update() is run
    _temp = 0;
    _s = 0;
    _r = 0;
    _score = 0;

    if (ppl_cover_box(pad)) {
        _ppl.set_pos(temp_ppl_pos);
    }
    box_cover_cross1_score(pad);
    box_cover_cross2_score(pad);
    set_score();

}

void PushingEngine::check_ppl_box1_touching(Gamepad &pad) // check if ppl can push the box1 and which direction
{
    Vector2D b1_pos = _b1.get_pos();
    Vector2D ppl_pos = _ppl.get_pos();

    if (b1_pos.y == ppl_pos.y) {
        if((ppl_pos.x-b1_pos.x) ==8) {
            _s = 1; // can push to left
        } else if((b1_pos.x-ppl_pos.x)==8) {
            _s = 2; // can push to right
        }
    } else if (b1_pos.x == ppl_pos.x) {
        if((ppl_pos.y-b1_pos.y) ==8) {
            _s = 4; // can push up
        } else if((b1_pos.y-ppl_pos.y)==8) {
            _s = 3; // can push down
        }
    } else {
        _s = 0;
    }
}

void PushingEngine::check_ppl_box2_touching(Gamepad &pad) // check if ppl can push the box2 and which direction
{
    Vector2D b2_pos = _b2.get_pos();
    Vector2D ppl_pos = _ppl.get_pos();

    if (b2_pos.y == ppl_pos.y) {
        if((ppl_pos.x-b2_pos.x) ==8) {
            _r = 1; // can push to left
        } else if((b2_pos.x-ppl_pos.x)==8) {
            _r = 2; // can push to right
        }
    } else if (b2_pos.x == ppl_pos.x) {
        if((ppl_pos.y-b2_pos.y) ==8) {
            _r = 4; // can push up
        } else if((b2_pos.y-ppl_pos.y)==8) {
            _r = 3; // can push down
        }
    } else {
        _r = 0;
    }
}


void PushingEngine::draw(N5110 &lcd,int barrier_x,int barrier_y)
{
    // draw the elements in the LCD buffer
    // pitch
    lcd.drawLine(0,2,83,2,1);
    lcd.drawLine(0,3,0,45,1);
    lcd.drawLine(1,45,83,45,1);
    lcd.drawLine(83,3,83,44,1);

    //draw the barrier
    lcd.drawSprite(barrier_x,barrier_y,8,8,(int *)barrier);
    //crosses
    _c1.draw(lcd);
    _c2.draw(lcd);
    // ppl
    _ppl.draw(lcd);
    // boxes
    _b1.draw(lcd);
    _b2.draw(lcd);

}

void PushingEngine::hold_ppl_box1_wall(Gamepad &pad) // hold box1 on the screen
{
    Vector2D b1_pos = _b1.get_pos();

    if (b1_pos.x == 2) {
        if(_s == 1) {
            _temp=1;
        }
    }
    if (b1_pos.x == 74) {
        if(_s == 2) {
            _temp=2;
        }
    }
    if (b1_pos.y == 4) {
        if(_s == 4) {
            _temp=3;
        }
    }
    if (b1_pos.y == 36) {
        if(_s == 3) {
            _temp=4;
        }
    }
}

void PushingEngine::hold_ppl_box2_wall(Gamepad &pad) // hold box2 on the screen
{
    Vector2D b2_pos = _b2.get_pos();

    if (b2_pos.x == 2) {
        if(_r == 1) {
            _temp=1;
        }
    }
    if (b2_pos.x == 74) {
        if(_r == 2) {
            _temp=2;
        }
    }
    if (b2_pos.y == 4) {
        if(_r == 4) {
            _temp=3;
        }
    }
    if (b2_pos.y == 36) {
        if(_r == 3) {
            _temp=4;
        }
    }
}

bool PushingEngine::ppl_cover_box(Gamepad &pad) // check if the ppl cover the box
// return true if covered
{
    Vector2D b1_pos = _b1.get_pos();
    Vector2D b2_pos = _b2.get_pos();
    Vector2D ppl_pos = _ppl.get_pos();

    if ((b1_pos.x == ppl_pos.x &&b1_pos.y == ppl_pos.y)||(b2_pos.x == ppl_pos.x &&b2_pos.y == ppl_pos.y)) {
        return true;
    } else {
        return false;
    }
}
void PushingEngine::box_cover_cross1_score(Gamepad &pad) // score if box cover cross1
{
    Vector2D c1_pos = _c1.get_pos();
    Vector2D b1_pos = _b1.get_pos();
    Vector2D b2_pos = _b2.get_pos();

    if(c1_pos.x==b1_pos.x && c1_pos.y==b1_pos.y) {
        _score ++;
    }
    if(c1_pos.x==b2_pos.x && c1_pos.y==b2_pos.y) {
        _score ++;
    }
}

void PushingEngine::box_cover_cross2_score(Gamepad &pad) // score if box cover cross2
{
    Vector2D c2_pos = _c2.get_pos();
    Vector2D b1_pos = _b1.get_pos();
    Vector2D b2_pos = _b2.get_pos();

    if(c2_pos.x==b1_pos.x && c2_pos.y==b1_pos.y) {
        _score ++;
    }
    if(c2_pos.x==b2_pos.x && c2_pos.y==b2_pos.y) {
        _score ++;
    }
}

int PushingEngine::set_score() // set the score for the game
{
    printf("score = %d\n",_score);
    return _score;
}

Vector2D PushingEngine::get_menu(N5110 &lcd,Gamepad &pad)
{
    _menu.update(pad);
    _menu.print(lcd,pad);
    Vector2D p = _menu.get_level();
    return p;
}

void PushingEngine::reset_menu()
{
    Vector2D p = {0,0};
    _menu.set_level(p);
}

void PushingEngine::introduction(N5110 &lcd,Gamepad &pad)
{
        lcd.clear();
        lcd.printString(" Use A,B,X,Y ",0,0);
        lcd.printString("Push the Boxes",0,2);
        lcd.printString("to the Crosses",0,4);
        lcd.refresh();
        wait(3); lcd.clear();
        lcd.printString("Make sure you",0,0);
        lcd.printString("don't Push box",0,2);
        lcd.printString("against wall",0,4);
        lcd.refresh();
        wait(3); lcd.clear();
        lcd.printString("Also there is",0,0);
        lcd.printString("barrier which",0,2);
        lcd.printString("can't be moved",0,4);
        lcd.refresh(); 
}