#include "Menu.h"

Menu::Menu()
{

}

Menu::~Menu()
{

}

void Menu::init(int bj0,int bjoy0)
{
    _x = bj0;
    _y = bjoy0;

}

void Menu::print(N5110 &lcd,Gamepad &pad)
{   
    lcd.clear();
    lcd.printString("Use Joystick",0,0);
    lcd.printString("Select & Enter",0,1);
    lcd.printString("A: Level 1",0,2);
    lcd.printString("B: Level 2",0,3);
    lcd.printString("C: Level 3",0,4);
    lcd.printString("How to Play",0,5);
    int temp = _x*8+19;
    lcd.drawCircle(69,temp,3,FILL_BLACK);
    lcd.refresh();
    wait(0.2);
}

void Menu::update(Gamepad &pad) // process the reading of the joystick
{
     Direction d = pad.get_direction();  
    if (d == N) {
        _x = _x -1;
        wait(0.2);
    } 
     else if (d == S) {
        _x = _x +1;
        wait(0.2);
    } else {_x = _x;}
    
    if( _x<=0) {
        _x = 0;
    }
    if( _x>=3) {
        _x = 3;
        }
    if (pad.check_event(Gamepad::JOY_PRESSED)) {
        _y = 1;
        pad.tone(1500.0,0.1);
    } else {
        _y = 0;
    }
}

Vector2D Menu::get_level()
{
    Vector2D p = {_x,_y};
    return p;
}

void Menu::set_level(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}
