#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Cross Class
@author zhenwen liao, University of Leeds
@brief Controls the cross in the Sokoban game
@date 04 2019
*/
class Cross
{

public:
    /** Constructor */
    Cross();
    
    /** Destructor */
    ~Cross();
    
    /** Initialise the first position of Cross
    * @param x0 @details the first x position of cross (int)
    * @param y0 @details the first y position of cross (int)
    */
    void init(int x0, int y0);
    
    /** Draw the Cross accroading to the current _x,_y
    * @param lcd @details the object of screen 
    */
    void draw(N5110 &lcd);
    
    /** get the current position of cross */
    Vector2D get_pos();
    
    /** set the position of cross 
    * @param p @details the Vector form of cross (Vector2D)
    */
    void set_pos(Vector2D p);

private:
    // position of cross
    int _x;
    int _y;

};
