#include "Box.h"

const int box[8][8]= {
    {1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1},
    {1,1,0,0,0,0,1,1},
    {1,1,0,0,0,0,1,1},
    {1,1,0,0,0,0,1,1},
    {1,1,0,0,0,0,1,1},
    {1,1,1,1,1,1,1,1},
    {1,1,1,1,1,1,1,1},

};

Box::Box()
{

}

Box::~Box()
{

}

void Box::init(int x0, int y0)
{
    _x = x0;
    _y = y0;

}

void Box::draw(N5110 &lcd)
{
    lcd.drawSprite(_x,_y,8,8,(int *)box);
}

void Box::update(int s,int bb,int ba,int bx,int by,int barrier_x,int barrier_y)
{

    int temp1_x = _x;
    int temp1_y = _y;
    Vector2D p = {temp1_x,temp1_y};

    move_box(s,bb,ba,bx,by);

    if (_x == barrier_x && _y == barrier_y) {
        set_pos(p);
    } else {
        _x = _x;
        _y = _y;
    }

    hold_box_against_wall();

}

Vector2D Box::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}

void Box::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}

void Box::move_box(int s,int bb,int ba,int bx,int by) //move the box arrocding to
                                                      //the pos of ppl and reading of bottom
{
    if (s == 0) {
        _x = _x;
        _y = _y;
    }
    if (s == 1&&bx == 1) {
        _x = _x-8;
        _y = _y;
    }
    if (s == 2&&bb == 1) {
        _x = _x+8;
        _y = _y;
    }
    if (s == 3&&ba == 1) {
        _y = _y+8;
        _x = _x;
    }
    if (s == 4&&by == 1) {
        _y = _y-8;
        _x = _x;
    }
}

void Box::hold_box_against_wall()  // check the y origin to ensure that the paddle doesn't go off screen
{

    if (_y < 4) {
        _y = 4;
    }
    if (_y > 36) {
        _y = 36;
    }
    if (_x > 74) {
        _x = 74;
    }
    if (_x < 2) {
        _x = 2;
    }
}