#include "YouTube.h"

YouTube::YouTube()
{

}

YouTube::~YouTube()
{

}

// Function to initiate the youtube icon
void YouTube::init(int speed)
{    
    int position = rand() % 8; // randomise initial direction and position. 

    // 8 possibilities. Get random modulo and set velocities and position accordingly
    if (position == 0) {
        _x = -32;
        _y = 12;
        _velocity.x = speed * 2;
        _velocity.y = speed;
    } else if (position == 1) {
        _x = 20;
        _y = -11;
        _velocity.x = speed * 2;
        _velocity.y = speed *2;
    } else if (position == 2) {
        _x = 60;
        _y = -11;
        _velocity.x = -speed * 2;
        _velocity.y = speed *2;
    } else if (position == 3) {
        _x = 84;
        _y = 14;
        _velocity.x = -speed * 3;
        _velocity.y = speed;
    } else if (position == 4) {
        _x = 84;
        _y = 35;
        _velocity.x = -speed * 3;
        _velocity.y = -speed *2;
    } else if (position == 5) {
        _x = 60;
        _y = 48;
        _velocity.x = -speed * 2;
        _velocity.y = -speed *2;
    } else if (position == 6) {
        _x = 20;
        _y = 48;
        _velocity.x = speed * 2;
        _velocity.y = -speed *2;
    } else if (position == 7) {
        _x = -32;
        _y = 30;
        _velocity.x = speed * 3;
        _velocity.y = -speed *2;
    }
}

// Draw the youtube icon depending on the updated position
void YouTube::draw(N5110 &lcd)
{
    int YouTube_data[11][32] = {
        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,0,1,0,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,1,1,0,0,0,1,1},
        {1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,1,1},
        {1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,1,1},
        {1,0,1,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,0,1,1,0,0,0,1,1},
        {1,0,0,1,0,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,1,1},
        {1,0,0,1,0,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,1,1},
        {1,0,0,1,0,0,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,0,1,0,0,1,1,0,0,0,1,1},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };

    lcd.drawSprite(_x, _y, 11, 32, (int*)YouTube_data);
}

// Update the position of the youtube icon dependent on the speed
void YouTube::update()
{
    _x += _velocity.x;
    _y += _velocity.y;
}

// Function used to set the velocity of the youtube icon
void YouTube::set_velocity(Vector2D v)
{
    _velocity.x = v.x;
    _velocity.y = v.y;
}

// Function used to fetch the current velocity of the youtube icon
Vector2D YouTube::get_velocity()
{
    Vector2D v = {_velocity.x,_velocity.y};
    return v;
}

// Function used to fetch the current position of the youtube icon
Vector2D YouTube::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}

// Function used to set the current position of the youtube icon
void YouTube::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}