#ifndef COIN_H
#define COIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Coin Class
@author Yiu Fai Kwok, University of Leeds
@brief Controls the coin in Game_1 
@date 25/03/2019
*/ 
class Coin
{

public:
    /** Constructor */
    Coin();
    /** Deconstructor */
    ~Coin();
    
    
    /**
     * @brief Initialize the class parameters
     * @param speed (int)
     * @details Initialize the coin's position and speed
     */
    void init(int speed);
    
    /**
     * @brief Draw the object - coin in Game 1
     * @details Draw the block on lcd screen
     */
    void draw(N5110 &lcd);
    
    /**
     * @brief Update the coin
     * @details Update the coin position 
     */
    void update();
    
    /// accessors and mutators
    /**
     * @brief Set the speed - coin in Game 1
     * @param speed (int)
     * @details Set the speed of the coin according to the level of difficulty determined by year
     */
    void set_velocity(int speed);
    
    /**
     * @brief Get the speed
     * @return the value of speed (int)
     * @details Return the speed of the coin
     */
    int get_velocity();
    
    /**
     * @brief Get the position
     * @return The current position (Vector2D)
     * @details Return the position of the coin
     */
    Vector2D get_pos();
    
    /**
     * @brief Set the position
     * @param The position p (Vector2D)
     * @details Set the position of the coin
     */
    void set_pos(Vector2D p);
    
private:
    int _speed;
    int _x;
    int _y;
};
#endif