#ifndef EXAM_H
#define EXAM_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Score.h"

/** Exam Class
* @brief This class is the game engine for the mini-game EXAM
* @version 1.0
* @author Yiu Fai Kwok
* @date April, 2019
*/

class Exam
{

public:
    /** Constructor */
    Exam();
    /** Deconstructor */
    ~Exam();
    
    /**
     * @brief EXAM title
     * @details The function draws the EXAM title and plays the introduction music to the EXAM mini game
     */
    void exam_title(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Exam questions for year 1
     * @param the value of point (int)
     * @return the number of correct answers (int)
     * @details The function takes in the number of successful missions (point) and display the answers to the questions accordingly. Then returns the amount of questions answered correctly to determine if the player passed the exam for year 1.
     */
    int exam_q_one(Gamepad &pad, N5110 &lcd, int point);
    
    /**
     * @brief Exam questions for year 2
     * @param the value of point (int)
     * @return the number of correct answers (int)
     * @details The function takes in the number of successful missions (point) and display the answers to the questions accordingly. Then returns the amount of questions answered correctly to determine if the player passed the exam for year 2.
     */
    int exam_q_two(Gamepad &pad, N5110 &lcd, int point);
    
    /**
     * @brief Exam questions for year 3
     * @param the value of point (int)
     * @return the number of correct answers (int)
     * @details The function takes in the number of successful missions (point) and display the answers to the questions accordingly. Then returns the amount of questions answered correctly to determine if the player passed the exam for year 3.
     */
    int exam_q_three(Gamepad &pad, N5110 &lcd, int point);
    
private:

    Score music;

};

#endif