#ifndef TITLES_H
#define TITLES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Score.h"

/** Titles Class
* @brief This class contains the main functions to draw all the title screens for different main pages of the game
* @version 1.0
* @author Yiu Fai Kwok
* @date April, 2019
*/

class Titles
{

public:
    /** Constructor */
    Titles();
    /** Deconstructor */
    ~Titles();
    
    /**
     * @brief Welcome function for Main Title
     * @details The function draws the main title sprite, plays the background music and instruct player to press start button
     */
    void welcome(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Grad title
     * @param character cha (int)
     * @details The function draws the graduation title and plays the music to the graduation
     */
    void Grad_title(Gamepad &pad, N5110 &lcd, int cha);
    
    /**
     * @brief Year One Title
     * @details The function draws the year one title sprite, plays the background music for level up
     */
    void year_one(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Year Two Title
     * @details The function draws the year two title sprite, plays the background music for level up
     */
    void year_two(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Year Three Title
     * @details The function draws the year three title sprite, plays the background music for level up
     */
    void year_three(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Term One Title
     * @details The function draws the term one title sprite, plays the background music for level up
     */
    void term_one(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Term Two Title
     * @details The function draws the term two title sprite, plays the background music for level up
     */
    void term_two(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Term Three Title
     * @details The function draws the term three title sprite, plays the background music for level up
     */
    void term_three(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Win Title
     * @details The function draws the win title sprite when player wins the mission
     */
    void win(N5110 &lcd);
    
    /**
     * @brief Lose Title
     * @details The function draws the lose title sprite when player loses the mission
     */
    void lose(N5110 &lcd);
    
    /**
     * @brief Pass Title
     * @details The function draws the pass title sprite when player passes the exam
     */
    void passed(N5110 &lcd);
    
    /**
     * @brief Fail Title
     * @details The function draws the Fail title sprite when player fails the exam
     */
    void failed(N5110 &lcd);
    
    /**
     * @brief Fail Title
     * @details The function draws the Fail title sprite when player fails the exam
     */
    void instruction(Gamepad &pad, N5110 &lcd);

private:

    Score music;

};

#endif