#include "Start.h"

Start::Start()
{

}

Start::~Start()
{

}

void Start::init(Gamepad &pad)
{
    // Initialize the positions for all objects
    _pos_x = 2;
    _pos_y = 8;
    _pos_cy = 5;
    _pos_sy = 9;
    _pos_by = 13;
    _alt = 0;
    pad.init();
}

void Start::starter_draw(N5110 &lcd)
{
    lcd.clear();
    _c1.draw_cha1_sprite(60, _pos_cy, lcd);     // Draw Charmander's sprite at position (60, 5)
    _s1.draw_cha1_sprite(32, _pos_sy, lcd);     // Draw Squirtle's sprite at position (32, 9)
    _b1.draw_cha1_sprite(4, _pos_by, lcd);      // Draw Bulbasaur's sprite at position (4, 13)
    lcd.drawRect(_pos_x, _pos_y, 25, 25, FILL_TRANSPARENT); //Draw selection box dependent on which Pokemon is currently being selected
    int instruct_data[15][69] = {
        {1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0},
        {1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
        {1,0,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,1,1,1,1,0,1,1,1,0,1,1,1,1,0},
        {1,1,1,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0},
        {1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0},
        {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0},
        {1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,1,1,1,1,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {1,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,0},
        {1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0},
        {0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,0,0,0,0,1,0,0,0},
        {0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,1,0,0,1},
        {1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1},
    };
    lcd.drawSprite(5, 33, 15, 69, (int*)instruct_data);     // Draw the instruction for choosing to read information or start the game
    lcd.refresh();
}

void Start::starter_update(Gamepad &pad)
{
    update_select(pad);         // Update the position of the selection box according to joystick input
    update_animation_b(pad);    // Update the animation of Bulbasaur if it is being selected
    update_animation_c(pad);    // Update the animation of Charmander if it is being selected
    update_animation_s(pad);    // Update the animation of Squirtle if it is being selected
    update_alt();               // Update the alt parameter to alter the sprites of the characters
}

Vector2D Start::update_select(Gamepad &pad)
{
    // Move the selection box according to the joystick input to move left and right
    if(pad.get_direction() == E && _pos_x < 58){_pos_x = _pos_x + 28; _pos_y = _pos_y - 4;}
    else if(pad.get_direction() == W && _pos_x > 2){_pos_x = _pos_x - 28;_pos_y = _pos_y + 4;}
    Vector2D p = {_pos_x, _pos_y};
    return p;
}

int Start::update_animation_b(Gamepad &pad)
{
    // Update the sprite's position according to parameter alt to create animation
    if(_alt == 0 && _pos_x == 2){_pos_by = 13;}
    else if(_alt == 1 && _pos_x == 2){_pos_by = 11;}
    int pos_by = _pos_by;
    return pos_by;
}

int Start::update_animation_c(Gamepad &pad)
{
    // Update the sprite's position according to parameter alt to create animation
    if(_alt == 0 && _pos_x == 58){_pos_cy = 3;}
    else if(_alt == 1 && _pos_x == 58){_pos_cy = 5;}
    int pos_cy = _pos_cy;
    return pos_cy;
}

int Start::update_animation_s(Gamepad &pad)
{
    // Update the sprite's position according to parameter alt to create animation
    if(_alt == 0 && _pos_x == 30){_pos_sy = 7;}
    else if(_alt == 1 && _pos_x == 30){_pos_sy = 9;}
    int pos_sy = _pos_sy;
    return pos_sy;
}

int Start::update_alt()
{
    if(_alt == 0){_alt = 1;}
    else {_alt = 0;}
    int alt = _alt;
    return alt;
}

int Start::get_select(Vector2D p)
{ 
    // Return a value to represent the character that is being selected by the selection box
    int select = 0;
    int x = p.x;
    if(x == 2) {select = 0;}
    else if(x == 30) {select = 1;}
    else if(x == 58) {select = 2;}
    return select;
}

void Start::intro(int select,Gamepad &pad, N5110 &lcd)
{
    // Fetch the files from Character file to display the character information
    if(select == 2){_c1.description(pad, lcd);}
    else if(select == 1){_s1.description(pad, lcd);}
    else if(select == 0){_b1.description(pad, lcd);}
}