#ifndef SCORE_H
#define SCORE_H

#include "Gamepad.h"
#include "mbed.h"
#include "Notes.h"
#include "N5110.h"
#include "Squirtle.h"
#include "Charmander.h"
#include "Bulbasaur.h"

/** Score Class
* @author Yiu Fai Kwok, University of Leeds
* @version 1.0
* @brief Score class containing all in-game background music files 
* @date 20/04/2019
*/ 

class Score
{
public:
    
    /** Constructor */
    Score();
    /** Deconstructor */
    ~Score();
    
    /**
     * @brief Title screen music
     * @details Background music played during title screen
     */
    void title_music(Gamepad &pad);
    
    /**
     * @brief Level up music
     * @details Background music played when player advance in level or year
     */
    void level_up(Gamepad &pad);
    
    /**
     * @brief Congratulation music
     * @details Background music played when player succesfully completed a mission
     */
    void congrats(Gamepad &pad);
    
    /**
     * @brief Coin music
     * @details Background music played when player successfully collected a coin in Game 1
     */
    void coin(Gamepad &pad);
    
    /**
     * @brief Evolution animation and music
     * @param character cha (int)
     * @param the value of year (int)
     * @details Background music played when player's character enters evolution, dependent on character selected (cha) and year of which player is currently in (year), initiate animation for evolution.
     */
    void evolution_music(Gamepad &pad, N5110 &lcd, int cha, int year);
    
    /**
     * @brief Congratulation music for evolution
     * @param character cha (int)
     * @param the value of year (int)
     * @details Background music played when player's character succesfully evolves, draw sprite of the evolved character
     */
    void congrats(Gamepad &pad, N5110 &lcd, int cha, int year);
    
    /**
     * @brief Draw sprite of pokemon
     * @param character cha (int)
     * @param the value of year (int)
     * @param the value of x (int)
     * @param the value of y (int)
     * @details Draw sprite of character depending on character selected (cha) and the year at which the player is in (year). Location of the sprite is determined by x and y to generate the moving name title.
     */
    void draw(N5110 &lcd, int cha, int year, int x, int y);
    
    /**
     * @brief Draw sprite of evolved pokemon
     * @param character cha (int)
     * @param the value of year (int)
     * @details Draw sprite of evolved character according to year (year) and character selected (cha)
     */
    void draw_cong(N5110 &lcd, int cha, int year);
    
    /**
     * @brief Music for winning
     * @details Background music played when player wins a mini game
     */
    void win(Gamepad &pad);
    
    /**
     * @brief Music for EXAM introduction
     * @details Background music played when player enters the EXAM
     */
    void exam_intro(Gamepad &pad);
    
    /**
     * @brief Draw sprite for graduation
     * @param character cha (int)
     * @param the value of year (int)
     * @param position x (int)
     * @details Draw sprite and animation for the graduation credit scene according to character picked
     */
    void draw_grad(N5110 &lcd, int cha, int year, int x);
    
    /**
     * @brief Graduation animation and music
     * @param character cha (int)
     * @details Background music played when player graduates, dependent on character selected (cha), initiate animation for the graduation.
     */
    void graduation(Gamepad &pad, N5110 &lcd, int cha);
    
private:
    Squirtle _s1;
    Charmander _c1;
    Bulbasaur _b1;
};
#endif