#include "Game_two.h"

Game_two::Game_two()
{
    
}

Game_two::~Game_two()
{
    
} 

//Enumerate instruction menu from page 1 - 3
enum Page {
    PAGE_1, PAGE_2, PAGE_3   
};

void Game_two::init(int speed, int cha, int r)
{
    // Set the speed of the objects
    _speed = speed;
    
    // Set the character being drawn
    _cha = cha;
    
    // Set the random parameter for determining difficulty level
    _rand = r; 
    
    // initialize round counter
    _count = 0;
    _alt = 0;
    
    // Game initiation
    _p1.init();
    _insta.init(_speed);
    _twitt.init(_speed);
    _face.init(_speed);
    _yt.init(_speed);
    
    // Create random parameter to determine which social app should be drawn
    srand(time(NULL));
    _type = rand() % 4; // randomise type.
    _so = rand() % 3;

}

// Function to render the images
void Game_two::render(N5110 &lcd, int cha)
{
    lcd.clear();
    draw(lcd, cha);
    lcd.refresh();    
}

// Function to read the input from the FXOS8700CQ device to get direction and magnitude
void Game_two::read_input(FXOS8700CQ &device)
{
    _d = device.get_direction();
    _mag = device.get_mag();
}

// Function to draw all objects in the game
void Game_two::draw(N5110 &lcd, int cha)
{
    int alt = update_alt();
    // draw player on lcd
    if(alt <= 1){_p1.draw(lcd, cha);}
    else {_p1.draw_alt(lcd, cha);}
    // spawn app icon
    if(_type < _rand) {
        if (_so == 0) {_insta.draw(lcd);}           // Draw instagram if _so is randomized to 0
        else if (_so == 1) {_face.draw(lcd);}       // Draw facebook if _so is randomized to 1
        else if (_so == 2) {_twitt.draw(lcd);}      // Draw twitter if _so is randomized to 2
    }
    else {_yt.draw(lcd);}                           // Draw youtube if _type < _rand
}

void Game_two::update(Gamepad &pad, N5110 &lcd, int cha)
{
    // check if the object is dodged
    // update the player's position
    // update the object's position
    // check if the object is collided with the player
    if (_type < _rand) {
        if (_so == 0){
            check_miss_insta(pad);
            _p1.update(_d,_mag);
            _insta.update();
            check_insta_collide(pad, lcd, cha);
        } else if (_so == 1){
            check_miss_face(pad);
            _p1.update(_d,_mag);
            _face.update();
            check_face_collide(pad, lcd, cha);
        } else if (_so == 2){
            check_miss_twitt(pad);
            _p1.update(_d,_mag);
            _twitt.update();
            check_twitt_collide(pad, lcd, cha);
        }
    }
    else {
        check_miss_yt(pad);
        _p1.update(_d,_mag);
        _yt.update();
        check_yt_collide(pad, lcd, cha);
    }
}

void Game_two::check_insta_collide(Gamepad &pad, N5110 &lcd, int cha)
{
    // read current object attributes
    Vector2D insta_pos = _insta.get_pos();
    Vector2D insta_speed = _insta.get_velocity();

    // check p1 first
    Vector2D p1_pos = _p1.get_pos();

    // see if object has hit the player by checking for overlaps
    if (cha == 1){
        if (
            (insta_pos.y >= p1_pos.y - 4) &&        //top
            (insta_pos.y <= p1_pos.y + 13) &&       //bottom
            (insta_pos.x >= p1_pos.x - 4) &&        //left
            (insta_pos.x <= p1_pos.x + 15)          //right
        ) 
        {
            // write new attributes
            _insta.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 2){
        if (
            (insta_pos.y >= p1_pos.y - 5) &&        //top
            (insta_pos.y <= p1_pos.y + 14) &&       //bottom
            (insta_pos.x >= p1_pos.x - 4) &&        //left
            (insta_pos.x <= p1_pos.x + 16)          //right
        ) 
        {
            // write new attributes
            _insta.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 3){
        if (
            (insta_pos.y >= p1_pos.y - 6) &&        //top
            (insta_pos.y <= p1_pos.y + 16) &&       //bottom
            (insta_pos.x >= p1_pos.x - 4) &&        //left
            (insta_pos.x <= p1_pos.x + 23)          //right
        ) 
        {
            // write new attributes
            _insta.init(_speed);
            gameover(lcd, pad);
        }
    }
}

void Game_two::check_miss_insta(Gamepad &pad)
{
    Vector2D insta_pos = _insta.get_pos();
    // player has missed
    if ((insta_pos.x > 84) || (insta_pos.x < -15) || (insta_pos.y < -15) || (insta_pos.y > 50)) {
        _insta.init(_speed);
        pad.tone(750.0,0.1);
        _count++;
        wait(0.1);
        _type = rand() % 8; // randomise type
        _so = rand() % 3;
    } 
}

void Game_two::check_face_collide(Gamepad &pad, N5110 &lcd, int cha)
{
    // read current object attributes
    Vector2D face_pos = _face.get_pos();
    Vector2D face_speed = _face.get_velocity();

    // check p1 first
    Vector2D p1_pos = _p1.get_pos();

    // see if object has hit the player by checking for overlaps
    if (cha == 1){
        if (
            (face_pos.y >= p1_pos.y - 8) &&         //top
            (face_pos.y <= p1_pos.y + 18) &&        //bottom
            (face_pos.x >= p1_pos.x - 6) &&         //left
            (face_pos.x <= p1_pos.x + 20)           //right
        ) 
        {
            // write new attributes
            _face.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 2){
        if (
            (face_pos.y >= p1_pos.y - 8) &&         //top
            (face_pos.y <= p1_pos.y + 21) &&        //bottom
            (face_pos.x >= p1_pos.x - 6) &&         //left
            (face_pos.x <= p1_pos.x + 21)           //right
        ) 
        {
            // write new attributes
            _face.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 3){
        if (
            (face_pos.y >= p1_pos.y - 8) &&         //top
            (face_pos.y <= p1_pos.y + 21) &&        //bottom
            (face_pos.x >= p1_pos.x - 6) &&         //left
            (face_pos.x <= p1_pos.x + 29)           //right
        ) 
        {
            // write new attributes
            _face.init(_speed);
            gameover(lcd, pad);
        }
    }
}

void Game_two::check_miss_face(Gamepad &pad)
{
    Vector2D face_pos = _face.get_pos();
    // player has missed
    if ((face_pos.x > 84) || (face_pos.x < -15) || (face_pos.y < -15) || (face_pos.y > 50)) {
        _face.init(_speed);
        pad.tone(750.0,0.1);
        _count++;
        wait(0.1);
        _type = rand() % 8; // randomise type
        _so = rand() % 3;
    } 
}

void Game_two::check_twitt_collide(Gamepad &pad, N5110 &lcd, int cha)
{
    // read current object attributes
    Vector2D twitt_pos = _twitt.get_pos();
    Vector2D twitt_speed = _twitt.get_velocity();

    // check p1 first
    Vector2D p1_pos = _p1.get_pos();

    // see if object has hit the player by checking for overlaps
    if (cha == 1){
        if (
            (twitt_pos.y >= p1_pos.y - 8) &&        //top
            (twitt_pos.y <= p1_pos.y + 18) &&       //bottom
            (twitt_pos.x >= p1_pos.x - 6) &&        //left
            (twitt_pos.x <= p1_pos.x + 20)          //right
        ) 
        {
            // write new attributes
            _twitt.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 2){
        if (
            (twitt_pos.y >= p1_pos.y - 8) &&        //top
            (twitt_pos.y <= p1_pos.y + 21) &&       //bottom
            (twitt_pos.x >= p1_pos.x - 6) &&        //left
            (twitt_pos.x <= p1_pos.x + 21)          //right
        ) 
        {
            // write new attributes
            _twitt.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 3){
        if (
            (twitt_pos.y >= p1_pos.y - 8) &&        //top
            (twitt_pos.y <= p1_pos.y + 21) &&       //bottom
            (twitt_pos.x >= p1_pos.x - 6) &&        //left
            (twitt_pos.x <= p1_pos.x + 29)          //right
        ) 
        {
            // write new attributes
            _twitt.init(_speed);
            gameover(lcd, pad);
        }
    }
}

void Game_two::check_miss_twitt(Gamepad &pad)
{
    Vector2D twitt_pos = _twitt.get_pos();
    // player has missed
    if ((twitt_pos.x > 84) || (twitt_pos.x < -15) || (twitt_pos.y < -15) || (twitt_pos.y > 50)) {
        _twitt.init(_speed);
        pad.tone(750.0,0.1);
        _count++;
        wait(0.1);
        _type = rand() % 8; // randomise type
        _so = rand() % 3;
    } 
}

void Game_two::check_yt_collide(Gamepad &pad, N5110 &lcd, int cha)
{
    // read current object attributes
    Vector2D yt_pos = _yt.get_pos();
    Vector2D yt_speed = _yt.get_velocity();

    // check p1 first
    Vector2D p1_pos = _p1.get_pos();

    // see if object has hit the player by checking for overlaps
    if (cha == 1){
        if (
            (yt_pos.y >= p1_pos.y - 8) &&       //top
            (yt_pos.y <= p1_pos.y + 18) &&      //bottom
            (yt_pos.x >= p1_pos.x - 25) &&      //left
            (yt_pos.x <= p1_pos.x + 20)         //right
        ) 
        {
            // write new attributes
            _yt.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 2){
        if (
            (yt_pos.y >= p1_pos.y - 8) &&       //top
            (yt_pos.y <= p1_pos.y + 21) &&      //bottom
            (yt_pos.x >= p1_pos.x - 25) &&      //left
            (yt_pos.x <= p1_pos.x + 21)         //right
        ) 
        {
            // write new attributes
            _yt.init(_speed);
            gameover(lcd, pad);
        }
    }
    if (cha == 3){
        if (
            (yt_pos.y >= p1_pos.y - 8) &&       //top
            (yt_pos.y <= p1_pos.y + 21) &&      //bottom
            (yt_pos.x >= p1_pos.x - 25) &&      //left
            (yt_pos.x <= p1_pos.x + 29)         //right
        ) 
        {
            // write new attributes
            _yt.init(_speed);
            gameover(lcd, pad);
        }
    }
}

void Game_two::check_miss_yt(Gamepad &pad)
{
    Vector2D yt_pos = _yt.get_pos();
    // player has missed
    if ((yt_pos.x > 84) || (yt_pos.x < -15) || (yt_pos.y < -15) || (yt_pos.y > 50)) {
        _yt.init(_speed);
        pad.tone(750.0,0.1);
        _count++;
        wait(0.1);
        _type = rand() % 8; // randomise type
        _so = rand() % 3;
    } 
}

void Game_two::set_count(int count)
{
    _count = count;
}

int Game_two::get_count()
{
    int count = _count;
    return count;
}

int Game_two::update_alt()
{
    if(_alt < 4){_alt = _alt++;}
    else {_alt=0;}
    int alt = _alt;
    return alt;
}

void Game_two::gameover(N5110 &lcd, Gamepad &pad)
{
    while(pad.check_event(Gamepad::B_PRESSED) == false) {
        lcd.clear();
        lcd.printString("You rushed ",0,0);
        lcd.printString("into social",0,1);
        lcd.printString("media!",0,2);
        lcd.printString("Game Over!",0,3);
        lcd.printString("Press B",0,5);
        lcd.refresh();
        wait(0.1);
    }
    _count = 30;
}

void Game_two::intro(Gamepad &pad, N5110 &lcd)
{
    Page currentPage = PAGE_1;
    int fps = 8.0;
    int instruct_data[4][7] = {
        {1,1,1,1,1,1,1},
        {0,1,1,1,1,1,0},
        {0,0,1,1,1,0,0},
        {0,0,0,1,0,0,0},
    };
    
    while(pad.check_event(Gamepad::A_PRESSED) == false){
        switch (currentPage) {
            case PAGE_1:
                lcd.clear();
                lcd.printString("Charmander",0,0);
                lcd.printString("is trying",0,1);
                lcd.printString("to study!",0,2);
                lcd.printString("Avoid all",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int *)instruct_data);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_2;}
                wait(1.0f/fps);
            break;
            case PAGE_2:
                lcd.clear();
                lcd.printString("distractions",0,0);
                lcd.printString("so he can pass",0,1);
                lcd.printString("the test by",0,2);
                lcd.printString("tilting the",0,3);
                lcd.printString("Gamepad!",0,4);
                lcd.printString("Press A",0,5);
                lcd.refresh();
                wait(1.0f/fps);
            break;
        }
    }
}