#include "Exam.h"

Exam::Exam()
{

}

Exam::~Exam()
{

}

//Enumerate instruction menu from page 1 - 3
enum Page {
    PAGE_1, PAGE_2, PAGE_3, PAGE_4, PAGE_5, PAGE_6, PAGE_7, PAGE_8, PAGE_9, PAGE_10
};

void Exam::exam_title(Gamepad &pad, N5110 &lcd)
{
    lcd.clear();
    int instruct_data[10][78] = {
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
    };
    lcd.drawSprite(4, 20, 10, 78, (int*)instruct_data);
    lcd.refresh();
    
    music.exam_intro(pad);
}

int Exam::exam_q_one(Gamepad &pad, N5110 &lcd, int point)
{
    pad.init();
    Page currentPage = PAGE_1;
    int fps = 8.0;
    int score = 0;
    int down[4][7] = {
        {1,1,1,1,1,1,1},
        {0,1,1,1,1,1,0},
        {0,0,1,1,1,0,0},
        {0,0,0,1,0,0,0},
    };
    int up[4][7] = {
        {0,0,0,1,0,0,0},
        {0,0,1,1,1,0,0},
        {0,1,1,1,1,1,0},
        {1,1,1,1,1,1,1},
    };
    
    while(pad.check_event(Gamepad::START_PRESSED) == false){
        switch (currentPage) {
            case PAGE_1:
                lcd.clear();
                lcd.printString("Question 1",0,0);
                lcd.printString("What is the",0,1);
                lcd.printString("cut off",0,2);
                lcd.printString("frequency ",0,3);
                lcd.printString("of a circuit",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_2; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_1; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_2:
                lcd.clear();
                lcd.printString("formed by a",0,0);
                lcd.printString("50k resistor",0,1);
                lcd.printString("and capacitor",0,2);
                lcd.printString("of 120pF in",0,3);
                lcd.printString("series?",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_3; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_1; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_3:
                lcd.clear();
                // Disable answers when no mission is successful
                if (point > 0){
                    lcd.printString("A. 26.5kHz",0,2);
                    lcd.printString("B. 2.61MHz",0,3);
                    lcd.printString("X. 26.3kHz",0,4);
                    lcd.printString("Y. 26.5MHz",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_2; pad.init_input();}
                if(pad.check_event(Gamepad::A_PRESSED) == true){
                    score++;
                    currentPage = PAGE_4;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::B_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)
                || (pad.check_event(Gamepad::Y_PRESSED) == true)){
                    currentPage = PAGE_4;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_4:
                lcd.clear();
                lcd.printString("Question 2",0,0);
                lcd.printString("What is the",0,1);
                lcd.printString("integration",0,2);
                lcd.printString("of function",0,3);
                lcd.printString("1/(6+5cos(x))",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_5; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_4; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_5:
                lcd.clear();
                lcd.printString("with respect",0,0);
                lcd.printString("to x for ",0,1);
                lcd.printString("[0,pi/2]?",0,2);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_6; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_4; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_6:
                lcd.clear();
                // Disable answers when only 1 mission is successful
                if(point > 1) {
                    lcd.printString("A. 0.1354",0,2);
                    lcd.printString("B. 2.617",0,3);
                    lcd.printString("X. 5.779",0,4);
                    lcd.printString("Y. 0.1766",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_5; pad.init_input();}
                if(pad.check_event(Gamepad::Y_PRESSED) == true){
                    score++;
                    currentPage = PAGE_7;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::A_PRESSED) == true)
                || (pad.check_event(Gamepad::B_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)){
                    currentPage = PAGE_7;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_7:
                lcd.clear();
                lcd.printString("Question 3",0,0);
                lcd.printString("What is the",0,1);
                lcd.printString("integration",0,2);
                lcd.printString("of function",0,3);
                lcd.printString("tan(x)",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_8; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_7; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_8:
                lcd.clear();
                lcd.printString("with respect",0,0);
                lcd.printString("to x?",0,1);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_9; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_7; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_9:
                lcd.clear();
                // Disable answers when only 2 missions are successful
                if(point > 2) {
                    lcd.printString("A. -ln|cos(x)|",0,2);
                    lcd.printString("B. -arctan(x)",0,3);
                    lcd.printString("X. -ln|sec(x)|",0,4);
                    lcd.printString("Y. -cot(1/x)",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_8; pad.init_input();}
                if(pad.check_event(Gamepad::A_PRESSED) == true){
                    score++;
                    currentPage = PAGE_10;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::B_PRESSED) == true)
                || (pad.check_event(Gamepad::Y_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)){
                    currentPage = PAGE_10;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_10:
                lcd.clear();
                lcd.printString("EXAM",0,0);
                lcd.printString("COMPLETE",0,1);
                lcd.printString("PRESS START",0,5);
                lcd.refresh();
                if(pad.check_event(Gamepad::START_PRESSED) == true) {pad.init_input();}
                wait(1.0f/fps);
            break;
        }
    }
    return score;
}

int Exam::exam_q_two(Gamepad &pad, N5110 &lcd, int point)
{
    pad.init();
    Page currentPage = PAGE_1;
    int fps = 8.0;
    int score = 0;
    int down[4][7] = {
        {1,1,1,1,1,1,1},
        {0,1,1,1,1,1,0},
        {0,0,1,1,1,0,0},
        {0,0,0,1,0,0,0},
    };
    int up[4][7] = {
        {0,0,0,1,0,0,0},
        {0,0,1,1,1,0,0},
        {0,1,1,1,1,1,0},
        {1,1,1,1,1,1,1},
    };
    
    while(pad.check_event(Gamepad::START_PRESSED) == false){
        //music.gym(pad, !finished);
        switch (currentPage) {
            case PAGE_1:
                lcd.clear();
                lcd.printString("Question 1",0,0);
                lcd.printString("A GaAs LED",0,1);
                lcd.printString("with bandgap",0,2);
                lcd.printString("of 1.42eV. ",0,3);
                lcd.printString("Calculate",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_2; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_1; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_2:
                lcd.clear();
                lcd.printString("the longest",0,0);
                lcd.printString("wavelength",0,1);
                lcd.printString("photon that ",0,2);
                lcd.printString("can be emitted",0,3);
                lcd.printString("by it.",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_3; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_1; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_3:
                lcd.clear();
                // Disable answers when no mission is successful
                if (point > 0){
                    lcd.printString("A. 913.52nm",0,2);
                    lcd.printString("B. 875.44nm",0,3);
                    lcd.printString("X. 688.91nm",0,4);
                    lcd.printString("Y. 31.29um",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_2; pad.init_input();}
                if(pad.check_event(Gamepad::B_PRESSED) == true){
                    score++;
                    currentPage = PAGE_4;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::A_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)
                || (pad.check_event(Gamepad::Y_PRESSED) == true)){
                    currentPage = PAGE_4;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_4:
                lcd.clear();
                lcd.printString("Question 2",0,0);
                lcd.printString("If the control",0,1);
                lcd.printString("signal for",0,2);
                lcd.printString("the switch is",0,3);
                lcd.printString("closed for",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_5; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_4; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_5:
                lcd.clear();
                lcd.printString("t(on) = 70us",0,0);
                lcd.printString("t(off) = 30us",0,1);
                lcd.printString("what is the",0,2);
                lcd.printString("switching",0,3);
                lcd.printString("frequency?",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_6; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_4; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_6:
                lcd.clear();
                // Disable answers when only 1 mission is successful
                if(point > 1) {
                    lcd.printString("A. 10kHz",0,2);
                    lcd.printString("B. 100kHz",0,3);
                    lcd.printString("X. 1MHz",0,4);
                    lcd.printString("Y. 10MHz",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_5; pad.init_input();}
                if(pad.check_event(Gamepad::A_PRESSED) == true){
                    score++;
                    currentPage = PAGE_7;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::Y_PRESSED) == true)
                || (pad.check_event(Gamepad::B_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)){
                    currentPage = PAGE_7;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_7:
                lcd.clear();
                lcd.printString("Question 3",0,0);
                lcd.printString("Let x(t) be a",0,1);
                lcd.printString("signal with",0,2);
                lcd.printString("x(t)=0 for t>2",0,3);
                lcd.printString("and t<6. What",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_8; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_7; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_8:
                lcd.clear();
                lcd.printString("is the value",0,0);
                lcd.printString("of x(-t+5) at",0,1);
                lcd.printString("t=0?",0,2);
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_9; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_7; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_9:
                lcd.clear();
                // Disable answers when only 2 missions are successful
                if(point > 2) {
                    lcd.printString("A. x(0)",0,2);
                    lcd.printString("B. x(1)",0,3);
                    lcd.printString("X. x(2)",0,4);
                    lcd.printString("Y. x(3)",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_8; pad.init_input();}
                if(pad.check_event(Gamepad::Y_PRESSED) == true){
                    score++;
                    currentPage = PAGE_10;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::B_PRESSED) == true)
                || (pad.check_event(Gamepad::A_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)){
                    currentPage = PAGE_10;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_10:
                lcd.clear();
                lcd.printString("EXAM",0,0);
                lcd.printString("COMPLETE",0,1);
                lcd.printString("PRESS START",0,5);
                lcd.refresh();
                if(pad.check_event(Gamepad::START_PRESSED) == true) {pad.init_input();}
                wait(1.0f/fps);
            break;
        }
    }
    return score;
}

int Exam::exam_q_three(Gamepad &pad, N5110 &lcd, int point)
{
    pad.init();
    Page currentPage = PAGE_1;
    int fps = 8.0;
    int score = 0;
    int down[4][7] = {
        {1,1,1,1,1,1,1},
        {0,1,1,1,1,1,0},
        {0,0,1,1,1,0,0},
        {0,0,0,1,0,0,0},
    };
    int up[4][7] = {
        {0,0,0,1,0,0,0},
        {0,0,1,1,1,0,0},
        {0,1,1,1,1,1,0},
        {1,1,1,1,1,1,1},
    };
    
    while(pad.check_event(Gamepad::START_PRESSED) == false){
        //music.gym(pad, !finished);
        switch (currentPage) {
            case PAGE_1:
                lcd.clear();
                // Disable answers and questions when no mission is successful
                if (point > 0){
                    lcd.printString("Question 1",0,0);
                    lcd.printString("The answer is",0,1);
                    lcd.printString("A",0,2);
                }
                else {
                    lcd.printString("$%^&*$%^&*",0,0);
                    lcd.printString("$%^&*$%^&*",0,1);
                    lcd.printString("$%^&*$%^&*",0,2);
                    lcd.printString("$%^&*$%^&*",0,3);
                }
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_2; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_1; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_2:
                lcd.clear();
                if (point > 0){
                    lcd.printString("A. ",0,2);
                    lcd.printString("B. ",0,3);
                    lcd.printString("X. ",0,4);
                    lcd.printString("Y. ",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_1; pad.init_input();}
                if(pad.check_event(Gamepad::A_PRESSED) == true){
                    score++;
                    currentPage = PAGE_3;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::B_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)
                || (pad.check_event(Gamepad::Y_PRESSED) == true)){
                    currentPage = PAGE_3;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_3:
                lcd.clear();
                // Disable answers and questions when only 1 mission is successful
                if (point > 1){
                    lcd.printString("Question 2",0,0);
                    lcd.printString("The answer is",0,1);
                    lcd.printString("B",0,2);
                }
                else {
                    lcd.printString("$%^&*$%^&*",0,0);
                    lcd.printString("$%^&*$%^&*",0,1);
                    lcd.printString("$%^&*$%^&*",0,2);
                    lcd.printString("$%^&*$%^&*",0,3);
                }
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_4; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_3; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_4:
                lcd.clear();
                // Disable answers and questions when only 2 missions are successful
                if (point > 1){
                    lcd.printString("A. ",0,2);
                    lcd.printString("B. ",0,3);
                    lcd.printString("X. ",0,4);
                    lcd.printString("Y. ",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_3; pad.init_input();}
                if(pad.check_event(Gamepad::B_PRESSED) == true){
                    score++;
                    currentPage = PAGE_5;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::A_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)
                || (pad.check_event(Gamepad::Y_PRESSED) == true)){
                    currentPage = PAGE_5;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_5:
                lcd.clear();
                if (point > 2){
                    lcd.printString("Question 3",0,0);
                    lcd.printString("The answer is",0,1);
                    lcd.printString("Y",0,2);
                }
                else {
                    lcd.printString("$%^&*$%^&*",0,0);
                    lcd.printString("$%^&*$%^&*",0,1);
                    lcd.printString("$%^&*$%^&*",0,2);
                    lcd.printString("$%^&*$%^&*",0,3);
                }
                lcd.drawSprite(39, 44, 4, 7, (int*)down);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_6; pad.init_input();}
                if(pad.get_direction() == N){currentPage = PAGE_5; pad.init_input();}
                wait(1.0f/fps);
            break;
            case PAGE_6:
                lcd.clear();
                if (point > 2){
                    lcd.printString("A. ",0,2);
                    lcd.printString("B. ",0,3);
                    lcd.printString("X. ",0,4);
                    lcd.printString("Y. ",0,5);
                }
                else {
                    lcd.printString("A. $%^&*",0,2);
                    lcd.printString("B. $%^&*",0,3);
                    lcd.printString("X. $%^&*",0,4);
                    lcd.printString("Y. $%^&*",0,5);
                }
                lcd.drawSprite(39, 0, 4, 7, (int*)up);
                lcd.refresh();
                if(pad.get_direction() == N){currentPage = PAGE_5; pad.init_input();}
                if(pad.check_event(Gamepad::Y_PRESSED) == true){
                    score++;
                    currentPage = PAGE_7;
                    pad.init_input();
                }
                if((pad.check_event(Gamepad::A_PRESSED) == true)
                || (pad.check_event(Gamepad::X_PRESSED) == true)
                || (pad.check_event(Gamepad::B_PRESSED) == true)){
                    currentPage = PAGE_7;
                    pad.init_input();
                }
                wait(1.0f/fps);
            break;
            case PAGE_7:
                lcd.clear();
                lcd.printString("EXAM",0,0);
                lcd.printString("COMPLETE",0,1);
                lcd.printString("PRESS START",0,5);
                lcd.refresh();
                if(pad.check_event(Gamepad::START_PRESSED) == true) {pad.init_input();}
                wait(1.0f/fps);
            break;
        }
    }
    return score;
}