#ifndef GAME_TWO_CHA_H
#define GAME_TWO_CHA_H

#include "N5110.h"
#include "Gamepad.h"
#include "Charmander.h"
#include "mbed.h"

/** Game Two Character Class
* @brief This class defines the parameters for the player and the character in the second mini-game
* @version 1.0
* @author Yiu Fai Kwok
* @date April, 2019
*/

class Game_two_cha
{

public:
    /** Constructor */
    Game_two_cha();
    /** Destructor */
    ~Game_two_cha();
    
    /**
     * @brief Initialize the class parameters
     * @details Initialize the character's position, speed and player score
     */
    void init();
    
    /**
     * @brief Draw the character
     * @param character parameter cha (int)
     * @details Draw the character on lcd screen, choose character depending on parameter (cha)
     */
    void draw(N5110 &lcd, int cha);
    
    /**
     * @brief Draw the character's alternative sprite
     * @param character parameter cha (int)
     * @details Draw the character's alternative sprite on lcd screen to create motion, choose character depending on parameter (cha)
     */
    void draw_alt(N5110 &lcd, int cha);
    
    /**
     * @brief Update the character
     * @param direction d (Direction)
     * @param magnitude mag (float)
     * @details Update the character position by referencing the joystick input on direction and magnitue
     */
    void update(Direction d,float mag);
    
    /**
     * @brief Set the score
     * @param score (int)
     * @details Set the score of the player
     */
    void add_score();
    
    /**
     * @brief Get the score
     * @return score (int)
     * @details Return the score of the player
     */
    int get_score();
    
    /**
     * @brief Get the position of the character
     * @return position of character (Vector2D)
     * @details Return the position of the character
     */
    Vector2D get_pos();
    
private:
    Charmander _c1;
    int _x;
    int _y;
    int _speed;
    int _score;
};

#endif