/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Thomas Foster
Username: el17ttds
Student ID Number: 201096550
Date: 11 / 05 / 2019
*/

#include "main.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Engine engine;

int main() {
    lcd.init();
    pad.init();
    opening();
    welcome();
    menu();

    lcd.printString("PLEASE RESET",0,5);
    lcd.refresh();
}

void init() {
  health = 3;
  score = 0;
  // initialise display and peripherals
  lcd.init();
  pad.init();

    // initialise any in game functions (e.g: sprites)
  engine.init(MAP_WIDTH,MAP_HEIGHT,SCREEN_WIDTH,SCREEN_HEIGHT);
}

void opening() {
  int happy[11][11] = {
    {0,0,1,1,1,1,1,1,1,0,0},
    {0,1,1,0,0,0,0,0,1,1,0},
    {1,1,0,0,0,0,0,0,0,1,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,0,0,0,0,0,0,0,0,0,1},
    {1,0,1,1,0,0,0,1,1,0,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,1,0,0,1,1,1,0,0,1,1},
    {0,1,1,0,0,0,0,0,1,1,0},
    {0,0,1,1,1,1,1,1,1,0,0},
  };
  int mad[11][11] = {
    {0,0,1,1,1,1,1,1,1,0,0},
    {0,1,1,0,0,0,0,0,1,1,0},
    {1,1,0,0,0,0,0,0,0,1,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,0,0,0,0,0,0,0,0,0,1},
    {1,0,0,1,1,1,1,1,0,0,1},
    {1,0,0,1,1,1,1,1,0,0,1},
    {1,1,0,1,1,1,1,1,0,1,1},
    {0,1,1,0,0,0,0,0,1,1,0},
    {0,0,1,1,1,1,1,1,1,0,0},
  };
  int eye[21][21] = {
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0},
    {0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
    {1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1},
    {1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1},
    {1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1},
    {1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1},
    {1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1},
    {1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1},
    {1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1},
    {0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
    {0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
  };
  lcd.drawSprite(37, 19, 11, 11, (int *)happy);
  lcd.refresh(),
  wait(1.0);
  for(int i = 84; i >= 0; i--) {
    lcd.clear();
    lcd.drawSprite(37, 19, 11, 11, (int *)happy);
    lcd.drawRect(i, 0, 84, 48, FILL_BLACK);
    lcd.refresh();
    wait(0.07);
  }
  wait(0.5);
  pad.tone(2000, 2);
  lcd.setBrightness(0.5);
  lcd.refresh();
  wait(1.0);
  for(int i = 0; i < 85; i++) {
    lcd.clear();
    lcd.drawSprite(i - 69, 1, 21, 21, (int *)eye);
    lcd.drawSprite(i - 69, 27, 21, 21, (int *)eye);
    lcd.drawSprite(49, 1, 21, 21, (int *)eye);
    lcd.drawSprite(49, 27, 21, 21, (int *)eye);
    lcd.drawSprite(37, 19, 11, 11, (int *)happy);
    lcd.drawRect(i, 0, 84, 48, FILL_BLACK);
    lcd.refresh();
    wait(0.02);
  }
  wait(1.5);
  lcd.clear();
  lcd.printString("     THEY     ",0,0);
  lcd.printString("     SAW     ",0,1);
  lcd.printString("     WHAT     ",0,2);
  lcd.printString("     YOU      ",0,3);
  lcd.printString("     DID      ",0,4);
  lcd.printString("     !!!      ",0,5);
  lcd.refresh();
  wait(2);
  for(int i = 0; i < 40; i++) {
    lcd.clear();
    lcd.drawSprite(15 - i, 1, 21, 21, (int *)eye);
    lcd.drawSprite(15 - i, 27, 21, 21, (int *)eye);
    lcd.drawSprite(49 + i, 1, 21, 21, (int *)eye);
    lcd.drawSprite(49 + i, 27, 21, 21, (int *)eye);
    lcd.drawSprite(37, 19, 11, 11, (int *)mad);
    lcd.refresh();
    wait(0.1);
  }
  lcd.clear();
  lcd.drawSprite(37, 19, 11, 11, (int *)mad);
  lcd.printString("AND THEY STOLE",0,0);
  lcd.printString(" YOUR BRIBES! ",0,5);
  lcd.refresh();
  wait(2.0);

  lcd.clear();
  lcd.printString("     KEEP     ",0,0);
  lcd.printString("     THE     ",0,1);
  lcd.printString("    SECRET     ",0,2);
  lcd.printString("     SAFE      ",0,3);
  lcd.printString("     !!!      ",0,4);
  lcd.refresh();
  wait(1.5);

  lcd.clear();
  lcd.printString("     KILL     ",0,0);
  lcd.refresh();
  wait(0.6);
  lcd.printString("     THEM     ",0,2);
  lcd.refresh();
  wait(0.6);
  lcd.printString("     ALL!     ",0,4);
  lcd.refresh();
  wait(1.0);
  lcd.clear();
}

void welcome() {
    lcd.printString(" THE SECRET!! ",0,0);
    lcd.refresh();
    wait(1.0);
    lcd.printString("By Thomas",0,2);
    lcd.printString("Foster",0,3);
    lcd.refresh();
    wait(2.0);

    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        lcd.printString("Press Start ",0,5);
        lcd.refresh();
        wait(0.2);
        lcd.printString("Press Start. ",0,5);
        lcd.refresh();
        wait(0.2);
        lcd.printString("Press Start.. ",0,5);
        lcd.refresh();
        wait(0.2);
        lcd.printString("Press Start... ",0,5);
        wait(0.2);
    }
}

void menu() {

    option = 0;
    lcd.init();

    while(option == 0) {

        lcd.printString("A - Play Now",0,2);
        lcd.printString("B - Tutorial",0,4);
        lcd.refresh();

        if (pad.check_event(Gamepad::A_PRESSED) == true) {
            option = 1;
        } else if (pad.check_event(Gamepad::B_PRESSED) == true) {
            option = 2;
        }

        wait(0.2);
    }
    lcd.init();
    pad.init();
    if (option == 1) {
        lcd.printString("  Play game?  ",0,0);
        ask();
    } else if (option == 2) {
        lcd.printString("Play tutorial?",0,0);
        ask();
    }
}

void ask() {
  begin = 0;
  lcd.printString("Are you sure?",0,3);
  lcd.printString("Back?   Start?",0,5);
  lcd.refresh();
  while (begin == 0) {
    if (pad.check_event(Gamepad::START_PRESSED) == true) {
      begin = 1;
    } else if(pad.check_event(Gamepad::BACK_PRESSED) == true) {
      begin = -1;
    }
    wait(0.2);
  }
  init();
  if (begin == -1) {
    menu();
  } else {
    init();
    if (option == 1) {
      gameLoop();
    } else {
      tutorial();
    }
  }
}

void gameLoop() {
  pad.tone(750, 1.0);
  while ( (health > 0) && (pad.check_event(Gamepad::START_PRESSED) == false) ) {
    lcd.refresh();
    engine.read(pad);
    engine.write(MAX_SPEED, pad, lcd);
    engine.render(lcd);
    health = engine.get_health();
    wait(0.1);
  }
  wait(0.2);
  score = engine.get_score();
  buffer[4];
  sprintf(buffer, " %2d", score);
  if (health > 0) {
    paused();
  } else {
    died();
  }
}

void paused() {
  while (pad.check_event(Gamepad::A_PRESSED) == false) {
    lcd.clear();
    lcd.printString("    PAUSED    ", 0, 0);
    lcd.printString(buffer, 0, 3);
    lcd.printString("coins", 28, 3);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press A", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  gameLoop();
}

void died() {
  wait(1.0);
  pad.init();
  lcd.clear();
  lcd.printString("      KO      ", 0, 0);
  lcd.refresh();
  for (int i = 0; i < 10; i++) {
    lcd.setBrightness(1 - (i / 10) );
    wait(0.15);
  }
  lcd.init();
  pad.leds_on();
  lcd.printString("EVERYONE KNOWS", 0, 0);
  lcd.printString(buffer, 0, 3);
  lcd.printString("coins", 28, 3);
  lcd.printString("recollected", 0, 4);
  while(pad.check_event(Gamepad::A_PRESSED) == false) {
    lcd.printString("Press A.", 0, 5);
    lcd.refresh();
    wait(0.1);
    lcd.printString("Press A .", 0, 5);
    lcd.refresh();
    wait(0.1);
    lcd.printString("Press A  .", 0, 5);
    lcd.refresh();
    wait(0.1);
  }
  menu();
}

void tutorial() {
  int mad[11][11] = {
    {0,0,1,1,1,1,1,1,1,0,0},
    {0,1,1,0,0,0,0,0,1,1,0},
    {1,1,0,0,0,0,0,0,0,1,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {1,0,0,0,0,0,0,0,0,0,1},
    {1,0,0,1,1,1,1,1,0,0,1},
    {1,0,0,1,1,1,1,1,0,0,1},
    {1,1,0,1,1,1,1,1,0,1,1},
    {0,1,1,0,0,0,0,0,1,1,0},
    {0,0,1,1,1,1,1,1,1,0,0},
  };
  int bribe[11][11] = {
    {0,0,0,1,1,1,1,1,0,0,0},
    {0,0,1,1,0,0,0,1,1,0,0},
    {0,1,1,0,0,1,0,0,1,1,0},
    {1,1,0,1,1,1,1,1,0,1,1},
    {1,0,0,1,0,1,0,0,0,0,1},
    {1,0,0,1,1,1,1,1,0,0,1},
    {1,0,0,0,0,1,0,1,0,0,1},
    {1,1,0,1,1,1,1,1,0,1,1},
    {0,1,1,0,0,1,0,0,1,1,0},
    {0,0,1,1,0,0,0,1,1,0,0},
    {0,0,0,1,1,1,1,1,0,0,0},
  };
  int eye[21][21] = {
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0},
    {0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
    {1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1},
    {1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1},
    {1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1},
    {1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1},
    {1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1},
    {1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1},
    {1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1},
    {0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
    {0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
  };
  lcd.printString(" Tutorial!! ",0,0);
  lcd.refresh();
  wait(1.0);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("Shoot The Eyes", 0, 1);
    lcd.printString("To Keep Your", 0, 2);
    lcd.printString("Secret!", 0, 3);
    lcd.drawSprite(42, 23, 21, 21, (int *)eye);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("Use Joystick", 0, 1);
    lcd.printString("To Move!", 0, 2);
    lcd.drawSprite(37, 23, 11, 11, (int *)mad);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("A To Shoot", 0, 1);
    lcd.printString("Forward", 0, 2);
    lcd.drawSprite(37, 23, 11, 11, (int *)mad);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("B To Shoot", 0, 1);
    lcd.printString("Backwards", 0, 2);
    lcd.drawSprite(37, 23, 11, 11, (int *)mad);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("AMMO |  HEALTH", 0, 1);
    lcd.printString("     LED     ", 0,3);
    lcd.printString("123  |  456", 0, 4);
    pad.leds_on();
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    pad.leds_off();
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("Recover Your", 0, 0);
    lcd.printString("Bribes Quickly", 0,1);
    lcd.printString("From Enemies", 0,2);
    lcd.drawSprite(37, 26, 11, 11, (int *)bribe);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("Difficulty", 0, 1);
    lcd.printString("Increases", 0,2);
    lcd.printString("With Time", 0,3);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  while (pad.check_event(Gamepad::B_PRESSED) == false) {
    lcd.clear();
    lcd.printString("Aim Well", 0, 1);
    lcd.printString("And", 0,2);
    lcd.printString("Stay Alive!", 0,3);
    lcd.refresh();
    wait(0.5);
    lcd.printString("Press B", 0, 5);
    lcd.refresh();
    wait(0.5);
  }
  wait(0.3);
  menu();
}
