/** My Missiles Class
* @brief Stores and draws location data for three missiles belonging to our Hero.
* @author Thomas Foster
* @date May, 2019
*/
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Missiles {

public:

  /** Constructor */
  Missiles();

  /** Initialises Missiles variables
  */
  void init();

  /** Re writes Missiles parameters
  * @param user change in x (int)
  * @param user change in y (int)
  * @param Direction (Direction)
  * @param Button A pressed (bool)
  * @param Button B pressed (bool)
  * @param map x position (int)
  * @param map y position (int)
  * @param Missile 1 hit (bool)
  * @param Missile 2 hit (bool)
  * @param Missile 3 hit (bool)
  * @param Gamepad library (Gamepad)
  * @param reload rate (int)
  */
  void write(int pix_x, int pix_y, Direction d, bool Apressed, bool Bpressed, int map_x, int map_y, bool m1_hit, bool m2_hit, bool m3_hit, Gamepad &pad, int rerate);

  /** Draws Missiles on screen
  * @param The N5110 library (N5110)
  */
  void draw(N5110 &lcd);

  /** Gets Missile 1 position
  * @return Missile 1 position (Vector2D)
  */
  Vector2D get_m1_pos();

  /** Gets Missile 2 position
  * @return Missile 2 position (Vector2D)
  */
  Vector2D get_m2_pos();

  /** Gets Missile 3 position
  * @return Missile 3 position (Vector2D)
  */
  Vector2D get_m3_pos();

  /** Calculates ammo
  * @param Gamepad library (Gamepad)
  */
  void show_ammo(Gamepad &pad);

private:
  void check_hit();
  void move_missile();
  void set_forward();
  void set_back();
  void direction();
  void check_collision_wall();
  void reload();

  int reload_rate;
  int _xStart;
  int _yStart;
  int _speed;
  float _changex;
  float _changey;
  int frame_counter;

  int frame_counter1;
  int frame_counter2;
  int frame_counter3;
  bool _ready1;
  bool _ready2;
  bool _ready3;

  int ammo;

  Direction _d;
  bool _Apressed;
  bool _Bpressed;

  int _pix_x;
  int _pix_y;
  int _map_x;
  int _map_y;

  bool _m1_hit;
  bool _m1;
  int _m1x;
  int _m1y;
  float _changex1;
  float _changey1;
  bool _m2_hit;
  bool _m2;
  int _m2x;
  int _m2y;
  float _changex2;
  float _changey2;
  bool _m3_hit;
  bool _m3;
  int _m3x;
  int _m3y;
  float _changex3;
  float _changey3;
};
