#include "Missiles.h"

Missiles::Missiles() {

}

void Missiles::init() {
  _d = N;
  _Apressed = false;
  frame_counter = 0;
  frame_counter1 = 0;
  frame_counter2 = 0;
  frame_counter3 = 0;
  _xStart = 42 - 1;
  _yStart = 24 - 1;
  _speed = 5;
  _changex = 0;
  _changey = -_speed; // Shoots up if no input
  _m1 = 0;
  _m1x = -1;
  _changex1 = 0;
  _m1y = -1;
  _changey1 = 0;
  _m2 = 0;
  _m2x = -1;
  _changex2 = 0;
  _m2y = -1;
  _changey2 = 0;
  _m3 = 0;
  _m3x = -1;
  _changex3 = 0;
  _m3y = -1;
  _changey3 = 0;
}

void Missiles::write(int pix_x, int pix_y, Direction d, bool Apressed, bool Bpressed, int map_x, int map_y, bool m1_hit, bool m2_hit, bool m3_hit, Gamepad &pad, int rerate) { // lcd for leds
  reload_rate = rerate;
  _Apressed = Apressed;
  _Bpressed = Bpressed;
  _d = d;
  _pix_x = pix_x;
  _pix_y = pix_y;
  _map_x = map_x;
  _map_y = map_y;
  _m1_hit = m1_hit;
  _m2_hit = m2_hit;
  _m3_hit = m3_hit;
  reload();
  check_hit();
  move_missile();
  if (_Apressed == true) {
    set_forward();
  } else if (_Bpressed == true) {
    set_back();
  }
  check_collision_wall();
  show_ammo(pad);
}

void Missiles::draw(N5110 &lcd) {
  if ( (_m1x >= 0 ) && (_m1y >= 0) ) {
    lcd.drawRect(_m1x, _m1y, 3, 3, FILL_TRANSPARENT);
  }
  if ( (_m2x >= 0 ) && (_m2y >= 0) ) {
    lcd.drawRect(_m2x, _m2y, 3, 3, FILL_TRANSPARENT);
  }
  if ( (_m3x >= 0 ) && (_m3y >= 0) ) {
    lcd.drawRect(_m3x, _m3y, 3, 3, FILL_TRANSPARENT);
  }
}

Vector2D Missiles::get_m1_pos() {
  if (_m1 == true) {
    Vector2D m1_pos = {_m1x, _m1y};
    return m1_pos;
  } else {return {_map_x, _map_y}; }
}

Vector2D Missiles::get_m2_pos() {
  if (_m2 == true) {
    Vector2D m2_pos = {_m2x, _m2y};
    return m2_pos;
  } else {return {_map_x, _map_y}; }
}

Vector2D Missiles::get_m3_pos() {
  if (_m3 == true) {
    Vector2D m3_pos = {_m3x, _m3y};
    return m3_pos;
  } else {return {_map_x, _map_y}; } // If missile doesnt exist, return a location that collides with no enemy.
}
//////////////////////////////////  PRIVATE FUNCTIONS ///////////////////////////////

void Missiles::reload() {
  if (_m1 == false) {
    frame_counter1++;
    _ready1 = false;
    if (frame_counter1 >= reload_rate) {
      _ready1 = true;
    }
  }
  if (_m2 == false) {
    frame_counter2++;
    _ready2 = false;
    if (frame_counter2 >= reload_rate) {
      _ready2 = true;
    }
  }
  if (_m3 == false) {
    frame_counter3++;
    _ready3 = false;
    if (frame_counter3 >= reload_rate) {
      _ready3 = true;
    }
  }
}

void Missiles::check_hit() {
  if (_m1_hit == true) {
    _m1 = false;
  }
  if (_m2_hit == true) {
    _m2 = false;
  }
  if (_m3_hit == true) {
    _m3 = false;
  }
}

void Missiles::move_missile() {
  if (_m1 == true) {
    _m1x += _changex1 - _pix_x;
    _m1y += _changey1 + _pix_y;
  } else {
    _m1x = -1;
    _m1y = -1;
  }
  if (_m2 == true) {
    _m2x += _changex2 - _pix_x;
    _m2y += _changey2 + _pix_y;
  } else {
    _m2x = -1;
    _m2y = -1;
  }
  if (_m3 == true) {
    _m3x += _changex3 - _pix_x;
    _m3y += _changey3 + _pix_y;
  } else {
    _m3x = -1;
    _m3y = -1;
  }
}

void Missiles::set_forward() {  // reverses direction to forward again
  if (_ready1 == true) {
    direction();
    _changex1 = -_changex;
    _changey1 = -_changey;
    _m1x = _xStart;
    _m1y = _yStart;
    _m1 = true;
    _ready1 = false;
    frame_counter1 = 0;
  } else if (_ready2 == true) {
    direction();
    _changex2 = -_changex;
    _changey2 = -_changey;
    _m2x = _xStart;
    _m2y = _yStart;
    _m2 = true;
    _ready2 = false;
    frame_counter2 = 0;
  } else if (_ready3 == true) {
    direction();
    _changex3 = -_changex;
    _changey3 = -_changey;
    _m3x = _xStart;
    _m3y = _yStart;
    _m3 = true;
    _ready3 = false;
    frame_counter3 = 0;
  }
}

void Missiles::set_back() {
  if (_ready1 == true) {
    direction();
    _changex1 = _changex;
    _changey1 = _changey;
    _m1x = _xStart;
    _m1y = _yStart;
    _m1 = true;
    _ready1 = false;
    frame_counter1 = 0;
  } else if (_ready2 == true) {
    direction();
    _changex2 = _changex;
    _changey2 = _changey;
    _m2x = _xStart;
    _m2y = _yStart;
    _m2 = true;
    _ready2 = false;
    frame_counter2 = 0;
  } else if (_ready3 == true) {
    direction();
    _changex3 = _changex;
    _changey3 = _changey;
    _m3x = _xStart;
    _m3y = _yStart;
    _m3 = true;
    _ready3 = false;
    frame_counter3 = 0;
  }
}

void Missiles::direction() { // Original design only shoots back.
  if (_d == N) {
    _changex = 0;
    _changey = _speed;
  } else if (_d == NE) {
    _changex = -(_speed / 1.414);
    _changey = _speed / 1.414;
  } else if (_d == E) {
    _changex = -_speed;
    _changey = 0;
  } else if (_d == SE) {
    _changex = -(_speed / 1.414);
    _changey = -(_speed / 1.414);
  } else if (_d == S) {
    _changex = 0;
    _changey = -_speed;
  } else if (_d == SW) {
    _changex = _speed / 1.414;
    _changey = -(_speed / 1.414);
  } else if (_d == W) {
    _changex = _speed;
    _changey = 0;
  } else if (_d == NW) {
    _changex = _speed / 1.414;
    _changey = _speed / 1.414;
  }
}

void Missiles::check_collision_wall() {
  if ( (_m1x <= _map_x + 42) ||
    (_m1x >= _map_x + 42 + 100) ||
    (_m1y <= _map_y + 24) ||
    (_m1y >= _map_y + 24 + 100) ) {
      _m1 = false;
      _m1x = -1;
      _m1y = -1;
    }
  if ( (_m2x <= _map_x + 42) ||
    (_m2x >= _map_x + 42 + 100) ||
    (_m2y <= _map_y + 24) ||
    (_m2y >= _map_y + 24 + 100) ) {
      _m2 = false;
      _m2x = -1;
      _m2y = -1;
    }
  if ( (_m3x <= _map_x + 42) ||
    (_m3x >= _map_x + 42 + 100) ||
    (_m3y <= _map_y + 24) ||
    (_m3y >= _map_y + 24 + 100) ) {
      _m3 = false;
      _m3x = -1;
      _m3y = -1;
    }
}

void Missiles::show_ammo(Gamepad &pad) {
  ammo = 0;
  frame_counter++;
  if (_ready1 == true) {
    ammo++;
  }
  if (_ready2 == true) {
    ammo++;
  }
  if (_ready3 == true) {
    ammo++;
  }
  if (ammo == 3) {
    pad.led(4, 1);
    pad.led(5, 1);
    pad.led(6, 1);
  } else if (ammo == 2) {
    pad.led(4, 1);
    pad.led(5, 1);
    pad.led(6, 0);
  } else if (ammo == 1) {
    pad.led(4, 1);
    pad.led(5, 0);
    pad.led(6, 0);
  } else {
    if (frame_counter%5 > 3) {
      pad.led(4, 1);
    } else {
      pad.led(4, 0);
    }
    pad.led(5, 0);
    pad.led(6, 0);
  }
}
