/** My Map Class
* @brief Stores and draws all map parameters.
* @author Thomas Foster
* @date May, 2019
*/
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Map {

public:

  /** Constructor */
  Map();

  /** Initialises Maps's variables
  * @param width (int)
  * @param width (int)
  * @param screen width (int)
  * @param screen height (int)
  */
  void init(int width, int height, int swidth, int sheight);

  /** Re writes Maps parameters
  * @param x position (int)
  * @param y position (int)
  */
  void write(int x1, int y1);

  /** Draws four rectangles on screen
  * @param The N5110 library (N5110)
  */
  void draw(N5110 &lcd);
private:
  void map_parameters();
  void horizontal();
  void veritical();
  int _w; // changing dimensions of top and left sides of map
  int _h;
  int _x1; // origin locations of map corners
  int _y1;
  int _x2;
  int _y2;
  int _swidth; // dimensions of screen
  int _sheight;
  int _width; // dimensions of avaliable space in game
  int _height;
  int _x1_pos;
  int _y1_pos;
};
