/** My Hero Class
* @brief Stores and draws sprite and health data for our Hero.
* @author Thomas Foster
* @date May, 2019
*/#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Hero {

public:

  /** Constructor */
  Hero();

  /** Initialises Hero's variables
  * @param screen width (int)
  * @param screen height (int)
  */
  void init(int swidth, int sheight);

  /** Draws Hero on screen
  * @param The N5110 library (N5110)
  */
  void draw(N5110 &lcd);

  /** Calculates current health
  * @param collision true (bool)
  * @param The Gamepad library (Gamepad)
  */
  void health(bool collision, Gamepad &pad);

  /** Gets health
  * @return current health (int)
  */
  int get_health();

private:
  int _x;
  int _y;
  int _health;
  int _health_rate;
  int frame_counter;
};
