/** My Engine Class
* @brief Runs all in game processes by calling on other classes
* @author Thomas Foster
* @date May, 2019
*/

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Hero.h"
#include "Map.h"
#include "Enemy.h"
#include "Bullets.h"
#include "Missiles.h"
#include "Coin.h"

class Engine { // Deals with the mechanics of the game by referencing other classes

public:
  /** Constructor */
  Engine();

  /** Initialise all in game variables
  * @param My chosen width for the map (int)
  * @param My chosen height for the map (int)
  * @param The default screen width (int)
  * @param The default screen height (int)
  */
  void init(int map_width, int map_height, int swidth, int sheight);

  /** Reads the user input
  * @param The Gamepad library (Gamepad)
  */
  void read(Gamepad &pad);

  /** Updates all in game variables
  * @param Hero's max speed (int)
  * @param The Gamepad library (Gamepad)
  * @param The N5110 library (N5110)
  */
  void write(int max_speed, Gamepad &pad, N5110 &lcd);

  /** Updates the screen
  * @param The N5110 library (N5110)
  */
  void render(N5110 &lcd);

  /** Gets health
  * @return Returns the Hero's health (int)
  */
  int get_health();

  /** Gets score
  * @return Returns the users current score (int)
  */
  int get_score();

private:
  void draw(N5110 &lcd);
  void draw_enemy(N5110 &lcd);
  void draw_coin(N5110 &lcd);
  void init_integers(int map_width, int map_height, int swidth, int sheight);
  void init_enemies();
  void init_bullets();
  void difficulty();
  void change_in_position(int max_speed);
  void change_origin();
  void get_missile_pos();
  void check_enemies();
  void assign_new_enemy();
  void write_enemies();
  void get_enemy_pos();
  void write_bullets();
  void check_bullet_collision();
  void check_enemy_collision();
  void hits();
  void write_coins();
  void scores();
  int check_hit(int ex, int ey);
  void show_health(Gamepad &pad);

  float _mag;
  Direction _d;
  bool Apressed;
  bool Bpressed;
  double _pix;
  int pix_x; //MAYBE int
  int pix_y;
  int _x1; // map origin co ordinates
  int _y1;
  int _map_width;
  int _map_height;

  int enemies;
  int max_enemies;
  int frame_counter;
  int spawn_rate;
  int reload_rate;
  int bull_speed;

  int e1_true; // alive or nahh
  int e2_true;
  int e3_true;
  int e4_true;
  int e5_true;
  int e6_true;
  int e7_true;
  int e8_true;
  int e9_true;
  int e10_true;

  int e_alive;

  int e1x;
  int e1y;
  int e2x;
  int e2y;
  int e3x;
  int e3y;
  int e4x;
  int e4y;
  int e5x;
  int e5y;
  int e6x;
  int e6y;
  int e7x;
  int e7y;
  int e8x;
  int e8y;
  int e9x;
  int e9y;
  int e10x;
  int e10y;

  int c1s;
  int c2s;
  int c3s;
  int c4s;
  int c5s;
  int c6s;
  int c7s;
  int c8s;
  int c9s;
  int c10s;

  int m1x;
  int m1y;
  int m2x;
  int m2y;
  int m3x;
  int m3y;
  bool m1_hit;
  bool m2_hit;
  bool m3_hit;

  int health;
  int score;
  bool collision;
};
