#include "Engine.h"

/////////////// objects ///////////////
Map map;
Hero hero;  // Our Hero
Missiles missiles;  // Our Heros ammunition
Enemy e1; // Our 10 possible enemies
Bullets b1; // Our 10 bullet classes for each enemy
Coin c1; // Our 10 coins for each enemy
Enemy e2;
Bullets b2;
Coin c2;
Enemy e3;
Bullets b3;
Coin c3;
Enemy e4;
Bullets b4;
Coin c4;
Enemy e5;
Bullets b5;
Coin c5;
Enemy e6;
Bullets b6;
Coin c6;
Enemy e7;
Bullets b7;
Coin c7;
Enemy e8;
Bullets b8;
Coin c8;
Enemy e9;
Bullets b9;
Coin c9;
Enemy e10;
Bullets b10;
Coin c10;

Engine::Engine() {

}

void Engine::init(int map_width, int map_height, int swidth, int sheight) {
  init_integers(map_width, map_height, swidth, sheight);
  map.init(map_width, map_height, swidth, sheight);
  hero.init(swidth, sheight);
  init_enemies();
  init_bullets();
  missiles.init();
}

void Engine::init_integers(int map_width, int map_height, int swidth, int sheight) {
  _map_width = map_width;
  _map_height = map_height;
  _x1 = -(swidth / 2) - (map_width - swidth) / 2; // _x1 and _y1 is the origin of the top left corner of map
  _y1 = -sheight - (map_height - sheight) / 2;
  frame_counter = 0;
  enemies = 1;
  max_enemies = 10;
  reload_rate = 5;
  bull_speed = 2;
  spawn_rate = 60;
  score = 0;
}

void Engine::init_enemies() {
  e1_true = 0; // 1 if enemy has been established, 0 if enemy is new and -1 if enemy doesnt yet exist
  e1.init();
  e2_true = -1;
  e2.init();
  e3_true = -1;
  e3.init();
  e4_true = -1;
  e4.init();
  e5_true = -1;
  e5.init();
  e6_true = -1;
  e6.init();
  e7_true = -1;
  e7.init();
  e8_true = -1;
  e8.init();
  e9_true = -1;
  e9.init();
  e10_true = -1;
  e10.init();
}

void Engine::init_bullets() {
  b1.init();
  b2.init();
  b3.init();
  b4.init();
  b5.init();
  b6.init();
  b7.init();
  b8.init();
  b9.init();
  b10.init();
}

void Engine::read(Gamepad &pad) {
  _mag = pad.get_mag();
  _d = pad.get_direction();
  Apressed = pad.check_event(Gamepad::A_PRESSED);
  Bpressed = pad.check_event(Gamepad::B_PRESSED);
}

void Engine::write(int max_speed, Gamepad &pad, N5110 &lcd) {
  frame_counter ++;
  collision = false;
  difficulty();
  change_in_position(max_speed);
  change_origin();
  map.write(_x1, _y1);
  missiles.write(pix_x, pix_y, _d, Apressed, Bpressed, _x1, _y1, m1_hit, m2_hit, m3_hit, pad, reload_rate);
  get_missile_pos();
  check_enemies();
  write_enemies();
  get_enemy_pos();
  write_bullets();
  check_bullet_collision();
  check_enemy_collision();
  hits();
  write_coins();
  scores();
  missiles.show_ammo(pad);
  hero.health(collision, pad);
  health = hero.get_health();
  show_health(pad);
}

void Engine::difficulty() {
  if (frame_counter >= 150) {
    frame_counter = 0;
    reload_rate += 2;
    bull_speed += 0.5;
    spawn_rate -= 10;
  }
  if (reload_rate > 40) {
    reload_rate = 40;
  } if (bull_speed > 5) {
    bull_speed = 5;
  } if (spawn_rate < 30) {
    spawn_rate = 30;
  }
}

void Engine::change_in_position(int max_speed) {
  _pix = _mag * max_speed;
  if (_d == N) {
    pix_x = 0;
    pix_y = _pix;
  } else if (_d == NE) {
    pix_x = _pix / 1.414;
    pix_y = _pix / 1.414;
  } else if (_d == E) {
    pix_x = _pix;
    pix_y = 0;
  } else if (_d == SE) {
    pix_x = _pix / 1.414;
    pix_y = -(_pix / 1.414);
  } else if (_d == S) {
    pix_x = 0;
    pix_y = -_pix;
  } else if (_d == SW) {
    pix_x = -(_pix / 1.414);
    pix_y = -(_pix / 1.414);
  } else if (_d == W) {
    pix_x = -_pix;
    pix_y = 0;
  } else if (_d == NW) {
    pix_x = -(_pix / 1.414);
    pix_y = _pix / 1.414;
  } else {
    pix_x = 0;
    pix_y = 0;
  }
}

void Engine::change_origin() {
  _x1 -= pix_x; // changes origins by user input amount
  _y1 += pix_y;
  if (_x1 < -_map_width) {
    _x1 = -_map_width;
  } else if (_x1 > 0) {
    _x1 = 0;
  }
  if (_y1 < -_map_height) {
    _y1 = -_map_height;
  } else if (_y1 > 0) {
    _y1 = 0;
  }
}

void Engine::get_missile_pos() {
  Vector2D m1_pos = missiles.get_m1_pos();
  Vector2D m2_pos = missiles.get_m2_pos();
  Vector2D m3_pos = missiles.get_m3_pos();
  m1x = m1_pos.x;
  m1y = m1_pos.y;
  m2x = m2_pos.x;
  m2y = m2_pos.y;
  m3x = m3_pos.x;
  m3y = m3_pos.y;
}

void Engine::check_enemies() {  // should an enemy be created?
  if (frame_counter%(spawn_rate + 1) >= spawn_rate) {
    if (enemies < max_enemies) {
      enemies++;
      assign_new_enemy();
    }
  }
}

void Engine::assign_new_enemy() {
  if (e1_true == -1) {
    e1_true = 0;
  } else if (e2_true == -1) {
    e2_true = 0;
  } else if (e3_true == -1) {
    e3_true = 0;
  } else if (e4_true == -1) {
    e4_true = 0;
  } else if (e5_true == -1) {
    e5_true = 0;
  } else if (e6_true == -1) {
    e6_true = 0;
  } else if (e7_true == -1) {
    e7_true = 0;
  } else if (e8_true == -1) {
    e8_true = 0;
  } else if (e9_true == -1) {
    e9_true = 0;
  } else if (e10_true == -1) {
    e10_true = 0;
  }
}

void Engine::write_enemies() { // Creates enemy if need be and sets ei_true to true
  e1_true = e1.write(e1_true, _x1, _y1);
  e2_true = e2.write(e2_true, _x1, _y1);
  e3_true = e3.write(e3_true, _x1, _y1);
  e4_true = e4.write(e4_true, _x1, _y1);
  e5_true = e5.write(e5_true, _x1, _y1);
  e6_true = e6.write(e6_true, _x1, _y1);
  e7_true = e7.write(e7_true, _x1, _y1);
  e8_true = e8.write(e8_true, _x1, _y1);
  e9_true = e9.write(e9_true, _x1, _y1);
  e10_true = e10.write(e10_true, _x1, _y1);
}

void Engine::get_enemy_pos() {
  e1x = e1.get_x();
  e1y = e1.get_y();
  e2x = e2.get_x();
  e2y = e2.get_y();
  e3x = e3.get_x();
  e3y = e3.get_y();
  e4x = e4.get_x();
  e4y = e4.get_y();
  e5x = e5.get_x();
  e5y = e5.get_y();
  e6x = e6.get_x();
  e6y = e6.get_y();
  e7x = e7.get_x();
  e7y = e7.get_y();
  e8x = e8.get_x();
  e8y = e8.get_y();
  e9x = e9.get_x();
  e9y = e9.get_y();
  e10x = e10.get_x();
  e10y = e10.get_y();
}

void Engine::write_bullets() {
  if (e1_true == 1) {
    b1.write(e1x, e1y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b1.init();
  } if (e2_true == 1) {
    b2.write(e2x, e2y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b2.init();
  } if (e3_true == 1) {
    b3.write(e3x, e3y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b3.init();
  } if (e4_true == 1) {
    b4.write(e4x, e4y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b4.init();
  } if (e5_true == 1) {
    b5.write(e5x, e5y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b5.init();
  } if (e6_true == 1) {
    b6.write(e6x, e6y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b6.init();
  } if (e7_true == 1) {
    b7.write(e7x, e7y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b7.init();
  } if (e8_true == 1) {
    b8.write(e8x, e8y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b8.init();
  } if (e9_true == 1) {
    b9.write(e9x, e9y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b9.init();
  } if (e10_true == 1) {
    b10.write(e10y, e10y, pix_x, pix_y, _x1, _y1, bull_speed);
  } else {
    b10.init();
  }
}

void Engine::check_bullet_collision() {
  if(b1.check_collision_hero()) {
    collision = true;
  } if (b2.check_collision_hero()) {
    collision = true;
  } if (b3.check_collision_hero()) {
    collision = true;
  } if (b4.check_collision_hero()) {
    collision = true;
  } if (b5.check_collision_hero()) {
    collision = true;
  } if (b6.check_collision_hero()) {
    collision = true;
  } if (b7.check_collision_hero()) {
    collision = true;
  } if (b8.check_collision_hero()) {
    collision = true;
  } if (b9.check_collision_hero()) {
    collision = true;
  } if (b10.check_collision_hero()) {
    collision = true;
  }
}

void Engine::check_enemy_collision() {
  if(e1.check_collision()) {
    e1_true = -1;
    enemies--;
    collision = true;
  } if (e2.check_collision()) {
    e2_true = -1;
    enemies--;
    collision = true;
  } if (e3.check_collision()) {
    e3_true = -1;
    enemies--;
    collision = true;
  } if (e4.check_collision()) {
    e4_true = -1;
    enemies--;
    collision = true;
  } if (e5.check_collision()) {
    e5_true = -1;
    enemies--;
    collision = true;
  } if (e6.check_collision()) {
    e6_true = -1;
    enemies--;
    collision = true;
  } if (e7.check_collision()) {
    e7_true = -1;
    enemies--;
    collision = true;
  } if (e8.check_collision()) {
    e8_true = -1;
    enemies--;
    collision = true;
  } if (e9.check_collision()) {
    e9_true = -1;
    enemies--;
    collision = true;
  } if (e10.check_collision()) {
    e10_true = -1;
    enemies--;
    collision = true;
  }
}

void Engine::hits() {
  m1_hit = false;
  m2_hit = false;
  m3_hit = false;
  if (e1_true == 1) {
    e1_true = check_hit(e1x, e1y);
    if (e1_true == -1) {
      c1.set(e1x, e1y);
    }
  } if (e2_true == 1) {
    e2_true = check_hit(e2x, e2y);
    if (e2_true == -1) {
      c2.set(e2x, e2y);
    }
  } if (e3_true == 1) {
    e3_true = check_hit(e3x, e3y);
    if (e3_true == -1) {
      c3.set(e3x, e3y);
    }
  } if (e4_true == 1) {
    e4_true = check_hit(e4x, e4y);
    if (e4_true == -1) {
      c4.set(e4x, e4y);
    }
  } if (e5_true == 1) {
    e5_true = check_hit(e5x, e5y);
    if (e5_true == -1) {
      c5.set(e5x, e5y);
    }
  } if (e6_true == 1) {
    e6_true = check_hit(e6x, e6y);
    if (e6_true == -1) {
      c6.set(e6x, e6y);
    }
  } if (e7_true == 1) {
    e7_true = check_hit(e7x, e7y);
    if (e7_true == -1) {
      c7.set(e7x, e7y);
    }
  } if (e8_true == 1) {
    e8_true = check_hit(e8x, e8y);
    if (e8_true == -1) {
      c8.set(e8x, e8y);
    }
  } if (e9_true == 1) {
    e9_true = check_hit(e9x, e9y);
    if (e9_true == -1) {
      c9.set(e9x, e9y);
    }
  } if (e10_true == 1) {
    e10_true = check_hit(e10x, e10y);
    if (e10_true == -1) {
      c10.set(e10x, e10y);
    }
  }
}

int Engine::check_hit(int ex, int ey) {
  e_alive = 1;
  if ( ( (ex + 19) >= m1x) &&
    ( (ex - 2) <= (m1x + 2) )  &&
    ( (ey + 19) >= m1y) &&
    ( (ey - 2) <= (m1y + 2) ) ) {
    m1_hit = true;
    e_alive = -1;
    enemies--;
  } else if ( ( (ex + 19) >= m2x) &&
    ( (ex - 2) <= (m2x + 2) )  &&
    ( (ey + 19) >= m2y) &&
    ( (ey - 2) <= (m2y + 2) ) ) {
    m2_hit = true;
    e_alive = -1;
    enemies--;
  } else if ( ( (ex + 19) >= m3x) &&
    ( (ex - 2) <= (m3x + 2) )  &&
    ( (ey + 19) >= m3y) &&
    ( (ey - 2) <= (m3y + 2) ) ) {
    m3_hit = true;
    e_alive = -1;
    enemies--;
  }
  return e_alive;
}

void Engine::write_coins() {
  c1.write(-pix_x, pix_y);
  c2.write(-pix_x, pix_y);
  c3.write(-pix_x, pix_y);
  c4.write(-pix_x, pix_y);
  c5.write(-pix_x, pix_y);
  c6.write(-pix_x, pix_y);
  c7.write(-pix_x, pix_y);
  c8.write(-pix_x, pix_y);
  c9.write(-pix_x, pix_y);
  c10.write(-pix_x, pix_y);
}

void Engine::scores() {
  c1s = c1.get_score();
  c2s = c2.get_score();
  c3s = c3.get_score();
  c4s = c4.get_score();
  c5s = c5.get_score();
  c6s = c6.get_score();
  c7s = c7.get_score();
  c8s = c8.get_score();
  c9s = c9.get_score();
  c10s = c10.get_score();

  score += c1s + c2s + c3s + c4s + c5s + c6s + c7s + c8s + c9s + c10s;
}

void Engine::show_health(Gamepad &pad) {
  if (health == 3) {
    pad.led(1, 1);
    pad.led(2, 1);
    pad.led(3, 1);
  } else if (health == 2) {
    pad.led(1, 1);
    if (frame_counter%10 < 5) {
      pad.led(2, 1);
    } else {
      pad.led(2, 0);
    }
    pad.led(3, 0);
  } else {
    if (frame_counter%4 < 2) {
      pad.led(1, 1);
    } else {
      pad.led(1, 0);
    }
    pad.led(2, 0);
    pad.led(3, 0);
  }
}

void Engine::render(N5110 &lcd) {

  lcd.clear();
  draw(lcd);
  lcd.setBrightness(0.5);
  lcd.refresh();
}

void Engine::draw(N5110 &lcd) {
  map.draw(lcd);
  hero.draw(lcd);
  missiles.draw(lcd);
  draw_coin(lcd);
  draw_enemy(lcd);
}

void Engine::draw_enemy(N5110 &lcd) {
  if (e1_true == 1) {
    e1.draw(lcd);
    b1.draw(lcd);
  }
  if (e2_true == 1) {
    e2.draw(lcd);
    b2.draw(lcd);
  }
  if (e3_true == 1) {
    e3.draw(lcd);
    b3.draw(lcd);
  }
  if (e4_true == 1) {
    e4.draw(lcd);
    b4.draw(lcd);
  }
  if (e5_true == 1) {
    e5.draw(lcd);
    b5.draw(lcd);
  }
  if (e6_true == 1) {
    e6.draw(lcd);
    b6.draw(lcd);
  }
  if (e7_true == 1) {
    e7.draw(lcd);
    b7.draw(lcd);
  }
  if (e8_true == 1) {
    e8.draw(lcd);
    b8.draw(lcd);
  }
  if (e9_true == 1) {
    e9.draw(lcd);
    b9.draw(lcd);
  }
  if (e10_true == 1) {
    e10.draw(lcd);
    b10.draw(lcd);
  }
}

void Engine::draw_coin(N5110 &lcd) {
  c1.draw(lcd);
  c2.draw(lcd);
  c3.draw(lcd);
  c4.draw(lcd);
  c5.draw(lcd);
  c6.draw(lcd);
  c7.draw(lcd);
  c8.draw(lcd);
  c9.draw(lcd);
  c10.draw(lcd);
}

int Engine::get_health() {
  return health;
}

int Engine::get_score() {
  return score;
}
