/** My Enemy Class
* @brief Stores and draws location and sprite data involving one enemy and checks for collisions with walls.
* @author Thomas Foster
* @date May, 2019
*/
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Enemy { // Deals with information regarding 1 enemy

public:
  /** Constructor */
  Enemy();

  /** Initialise all in game variables
  */
  void init();

  /** Updates all Enemy variables
  * @param Does the enemy exist? (int)
  * @param x position (int)
  * @param y position (int)
  */
  int write(int enemy_true, int x1, int y1);

  /** Draws Enemy sprite on screen
  * @param The N5110 library (N5110)
  */
  void draw(N5110 &lcd);

  /** Gets x position
  * @return Enemy x position (int)
  */
  int get_x();

  /** Gets y position
  * @return Enemy y position (int)
  */
  int get_y();

  /** Gets collision
  * @return Collision with wall (int)
  */
  bool check_collision();

private:
  void random_position();
  void valid_position();
  int _x;
  int _y;
  int _col;
  int _row;
  int _map_x;
  int _map_y;
  int _m;
  int _n;
};
