#include "Enemy.h"

Enemy::Enemy() {

}

void Enemy::init() {
  _x = -1;
  _y = -1;
}

int Enemy::write(int enemy_true, int x1, int y1) {  // use collision mechanic to re-draw if both enemies are in 1 location
  _map_x = x1;
  _map_y = y1;
  if (enemy_true == 1) {
    _x = _map_x + 42 + _col * 20; // x pos of left wall + screen width / 2 + x pos of enemy
    _y = _map_y + 24 + _row * 10; // y pos of left wall + screen height / 2 + y pos of enemy
    return 1;
  } else if (enemy_true == 0) { // create new enemy only if required
    random_position();
    return 1;
  } else {
    _x = -1;
    _y = -1;
    return -1;
  }
}

bool Enemy::check_collision() {
  if ( (_x + 19 >= 37) &&  // Hero centrepoint - radius - enemyRadius
    (_x <= 48) &&
    (_y + 19 >= 19) &&
    (_y <= 27) ) {
    return 1;
  } else {
    return 0;
  }
}

void Enemy::random_position() { // finds random postion for enemy out of 50 options
  _col = rand() % 5;
  _row = rand() % 5;
  _x = _map_x + 42 + _col * 20;
  _y = _map_y + 24 + _row * 20;
  valid_position();
  // spacesi = _row * 5 + _col; :: int Shows space 0 - 49. Could be useful.
}

void Enemy::valid_position() { // if enemy spawns too close to hero, re write enemy
  if ((_x >= 14) && (_x <= 60) && (_y >= 0) && (_y <= 52) ) {
    random_position();
  }
}

void Enemy::draw(N5110 &lcd) {
  // lcd.drawCircle( _x, _y, 10, FILL_BLACK);
  int const enemy[21][21] = {
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0},
    {0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
    {1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1},
    {1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1},
    {1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1},
    {1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1},
    {1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,1},
    {1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1},
    {1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1},
    {0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
    {0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
  };
  lcd.drawSprite(_x, _y, 21, 21, (int *)enemy);
}

int Enemy::get_x() {
  return _x;
}

int Enemy::get_y() {
  return _y;
}
