/** My Coin Class
* @brief Stores and draws location and sprite data for one coin.
* @author Thomas Foster
* @date May, 2019
*/
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Coin {

public:

  /** Constructor */
  Coin();

  /** Initialises coins variables
  */
  void init();

  /** Initialises coin location if becomes true
  * @param x position (int)
  * @param y position (int)
  */
  void set(int x, int y);

  /** Re writes coin location
  * @param x position (int)
  * @param y position (int)
  */
  void write(int x1, int y1);

  /** Draws Coin sprite on screen
  * @param The N5110 library (N5110)
  */
  void draw(N5110 &lcd);

  /** Gets score
  * @return current score (int)
  */
  int get_score();
private:
  void position();
  void collected();
  void expire();

  int frame_counter;
  int score;
  int _ctrue;

  int _x;
  int _y;
  int _pix_x;
  int _pix_y;
};
