#include "Coin.h"

Coin::Coin() {

}

void Coin::init() {
  _ctrue = -1;
  _x = -1;
  _y = -1;
}

void Coin::set(int x, int y) {
  _x = x;
  _y = y;
  frame_counter = 0;
  _ctrue = 1;
}

void Coin::write(int x1, int y1) {
  score = 0;
  _pix_x = x1;
  _pix_y = y1;
  if (_ctrue == 1) {
    position();
    collected();
    expire();
  } else {
    _x = -1;
    _y = -1;
  }
}

void Coin::draw(N5110 &lcd) {
  if ( (_x >= 0) && (_y >= 0) ) {
    int const coin[11][11] = {
      {0,0,0,1,1,1,1,1,0,0,0},
      {0,0,1,1,0,0,0,1,1,0,0},
      {0,1,1,0,0,1,0,0,1,1,0},
      {1,1,0,1,1,1,1,1,0,1,1},
      {1,0,0,1,0,1,0,0,0,0,1},
      {1,0,0,1,1,1,1,1,0,0,1},
      {1,0,0,0,0,1,0,1,0,0,1},
      {1,1,0,1,1,1,1,1,0,1,1},
      {0,1,1,0,0,1,0,0,1,1,0},
      {0,0,1,1,0,0,0,1,1,0,0},
      {0,0,0,1,1,1,1,1,0,0,0},
    };
    if (frame_counter%10 > 4) {
      lcd.drawSprite(_x, _y, 11, 11, (int *)coin);
    } else {
      lcd.drawCircle(_x + 5, _y + 5, 5, FILL_TRANSPARENT);
    }
  }
}

int Coin::get_score() {
  return score;
}

//////////////////////////////////// PRIVATE FUNCTIONS /////////////////////////////////

void Coin::position() {
  _x += _pix_x;
  _y += _pix_y;
}

void Coin::collected() {
  if ( (_x + 10 >= 38) &&
    (_x <= 46) &&
    (_y + 10 >= 20) &&
    (_y <= 28) ) {
    _ctrue = -1;
    score++;
    }
}

void Coin::expire() {
  frame_counter++;
  if (frame_counter == 60) {
    _ctrue = -1;
  }
}
