/** My Bullets Class
* @brief Stores and draws location data for three bullets belonging to one enemy and checks for collision with hero.
* @author Thomas Foster
* @date May, 2019
*/
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Bullets {

public:

  /** Constructor */
  Bullets();

  /** Initialises Bullets variables
  */
  void init();

  /** Re writes Bullets parameters
  * @param x position (int)
  * @param y position (int)
  * @param user change in x (int)
  * @param user change in y (int)
  * @param map x position (int)
  * @param map y position (int)
  * @param Bullet speed (int)
  */
  void write(int x, int y, int pix_x, int pix_y, int map_x, int map_y, int speed);

  /** Draws Bullets on screen
  * @param The N5110 library (N5110)
  */
  void draw(N5110 &lcd);

  /** Gets collision
  * @return collision with Hero (bool)
  */
  bool check_collision_hero();

private:
  void create_bullet();
  void set_bullet();
  void move_bullet();
  void check_collision_wall(int map_x, int map_y);
  int frame_counter;
  int i;
  int _xStart;
  int _yStart;
  int _pix_x;
  int _pix_y;
  int _speed;
  int fire_rate;
  int _b1;
  float _b1x;
  float _b1y;
  int changex1;
  int changey1;
  float ratio1;
  int _b2;
  float _b2x;
  float _b2y;
  int changex2;
  int changey2;
  float ratio2;
  int _b3;
  float _b3x;
  float _b3y;
  int changex3;
  int changey3;
  float ratio3;

  bool _collision;
};
