#include "Bullets.h"

Bullets::Bullets() {

}

void Bullets::init() {
  frame_counter = 0;
  fire_rate = 15;
  _xStart = -1;
  _yStart = -1;
  _b1 = -1; // Does the bullet exist? -1 if not. 0 if being created. 1 if exists
  _b1x = -1;
  _b1y = -1;
  _b2 = -1;
  _b2x = -1;
  _b2y = -1;
  _b3 = -1;
  _b3x = -1;
  _b3y = -1;
}

void Bullets::write(int x, int y, int pix_x, int pix_y, int map_x, int map_y, int speed) {
  frame_counter++;
  _speed = speed;
  _pix_x = pix_x;
  _pix_y = pix_y;
  _xStart = x;
  _yStart = y;
  move_bullet();
  if (frame_counter >= fire_rate) {
    create_bullet();
    frame_counter = 0;
  }
  set_bullet();
  check_collision_wall(map_x, map_y);
}

void Bullets::move_bullet() {
  if (_b1 == 1) {
    _b1x += changex1 / ratio1 - _pix_x;
    _b1y += changey1 / ratio1 + _pix_y;
  }
  if (_b2 == 1) {
    _b2x += changex2 / ratio2 - _pix_x;
    _b2y += changey2 / ratio2 + _pix_y;
  }
  if (_b3 == 1) {
    _b3x += changex3 / ratio3 - _pix_x;
    _b3y += changey3 / ratio3 + _pix_y;
  }
}

void Bullets::create_bullet() {
  if (_b1 == -1) {
    _b1 = 0;
  } else if (_b2 == -1) {
    _b2 = 0;
  } else if (_b3 == -1) {
    _b3 = 0;
  }
}

void Bullets::set_bullet() {
  if (_b1 == 0) {
    _b1x = _xStart - 1;
    _b1y = _yStart - 1;
    changex1 = 42 - _xStart;
    changey1 = 24 - _yStart;
    ratio1 = pow( ( (changex1 * changex1 + changey1 * changey1) / _speed), 0.5);
    _b1 = 1;
  }
  if (_b2 == 0) {
    _b2x = _xStart - 1;
    _b2y = _yStart - 1;
    changex2 = 42 - _xStart;
    changey2 = 24 - _yStart;
    ratio2 = pow( ( (changex2 * changex2 + changey2 * changey2) / _speed), 0.5);
    _b2 = 1;
  }
  if (_b3 == 0) {
    _b3x = _xStart - 1;
    _b3y = _yStart - 1;
    changex3 = 42 - _xStart;
    changey3 = 24 - _yStart;
    ratio3 = pow( ( (changex3 * changex3 + changey3 * changey3) / _speed), 0.5);
    _b3 = 1;
  }
}

void Bullets::check_collision_wall(int map_x, int map_y) {
  if ( (_b1x <= map_x + 42) ||
    (_b1x >= map_x + 42 + 100) ||
    (_b1y <= map_y + 24) ||
    (_b1y >= map_y + 24 + 100) ) {
      _b1 = -1;
      _b1x = -1;
      _b1y = -1;
    }
  if ( (_b2x <= map_x + 42) ||
    (_b2x >= map_x + 42 + 100) ||
    (_b2y <= map_y + 24) ||
    (_b2y >= map_y + 24 + 100) ) {
      _b2 = -1;
      _b2x = -1;
      _b2y = -1;
    }
  if ( (_b3x <= map_x + 42) ||
    (_b3x >= map_x + 42 + 100) ||
    (_b3y <= map_y + 24) ||
    (_b3y >= map_y + 24 + 100) ) {
      _b3 = -1;
      _b3x = -1;
      _b3y = -1;
    }
}

bool Bullets::check_collision_hero() {
  _collision = false;
  if ( (_b1x >= 36) &&
    (_b1x <= 46) &&
    (_b1y >= 18) &&
    (_b1y <= 28) ) {
    _b1 = -1;
    _b1x = -1;
    _b1y = -1;
    _collision = true;
  } if ( (_b2x >= 36) &&
    (_b2x <= 46) &&
    (_b2y >= 18) &&
    (_b2y <= 28) ) {
    _b2 = -1;
    _b2x = -1;
    _b2y = -1;
    _collision = true;
  } if ( (_b3x >= 36) &&
    (_b3x <= 46) &&
    (_b3y >= 18) &&
    (_b3y <= 28) ) {
    _b3 = -1;
    _b3x = -1;
    _b3y = -1;
    _collision = true;
  }
  if (_collision) {
    return true;
  } else {return false;}
}

void Bullets::draw(N5110 &lcd) {
  if ( (_b1x >= 0) && (_b1y >= 0) ) {
    lcd.drawRect(_b1x, _b1y, 3, 3, FILL_BLACK);
  }
  if ( (_b2x >= 0) && (_b2y >= 0) ) {
    lcd.drawRect(_b2x, _b2y, 3, 3, FILL_BLACK);
  }
  if ( (_b3x >= 0) && (_b3y >= 0) ) {
    lcd.drawRect(_b3x, _b3y, 3, 3, FILL_BLACK);
  }
}
