#ifndef VECTOR2DI_H
#define VECTOR2DI_H

#include <math.h> 
#define PI 3.14159265358979323846
/** Vector2Di class
 * @brief stores a 1x2 vector as _integer_ values.
 * @brief I am aware one exists already in Gamepad.h that uses floats
 * @brief but my project only uses vectors as integers and I didn't want to risk
 * @brief errors or complications arrising from converting back and forth between float and int.
 *
 * @brief Version 1.0
 * @author Thomas Caine
 * @date May 2019
 */
class Vector2Di {
    
    public:
    
        int x;
        int y;
        /** Negation operator overload
         *  Made the stepBack() function in Player.h easier to implement.
         *  Simply negates the x and y components of the vector.
         */
        Vector2Di operator -();
        /** Adds another vector to this one
         * @param vector - the Vector2Di object to be added to this vector.
         */
        void addVector(Vector2Di v);
        /** Rotate the current vector by a given angle
         *  @param angle - rotates the vector by a given angle with some simple trig functions
         *  The angle will always be a multiple of PI/2.
         */ 
        void rotateVector(double angle);
    
};

#endif