#ifndef PLAYER_H
#define PLAYER_H

#include "Maze.h"
#include "Vector2Di.h"

/** Player Class
 * @brief This class exists to store information about the player's location in the maze.
 * @brief more specifically, it stores their coordinates and their direction, both as vectors.
 * @brief It also facilitates the player's control of the camera via the gamepad.
 *
 * @brief Version 1.0
 * @author Thomas Caine
 * @date May 2019
 */
class Player {
    
    public:
        /** Create a Player object
         * @param maze - a maze object so the Player class has access to the maze matrix
         * @details This constructor does not set the player's position (not to the desired position anyway).
         * @details The player's proper position is assigned after the Player object's initial creation.
         */
        Player(Maze* maze);
        /** Check's the value of the cell in a specified direction from the current cell.
         * @param origin - vector of the co-ordinates to check from. Not necessarily the Player's current position.
         * @param angle - double representing the angle to rotate by before checking in front, will always be a multiple of PI/2.
         * @param checkVal - integer, checkLocation returns true if the checked cell has this value.
         */
        bool checkLocation(Vector2Di origin, double angle, int checkVal);
        /** Move the player's position forward one in their current direction.
         *  Performs validity check first. Won't increment position if cell infront is solid (i.e. 1)
         */
        void walk();
        /** Rotates the player's current direction by 90 degrees counter-clockwise.
         */
        void turnLeft();
        /** Rotates the player's current direction by 90 degrees clockwise.
         */
        void turnRight();
        /** Moves the player one cell backwards.
         *  Will not work if the cell behind the player is not open.
         */
        void stepBack();
            
        Vector2Di pos;
        Vector2Di direction;
        Maze* maze;
    
};

#endif // PLAYER_H