#include "Player.h"
#include "mbed.h"

const Vector2Di UP = {0,1};
const Vector2Di DOWN = {0,-1};

Player::Player(Maze* mazePtr) {
    maze = mazePtr;
    pos = UP; // {0,1} is a temporary value to initialise the variable
    direction = DOWN; // due to matrices index increasing as you go down
    // and their acces being [row][column], the standard (x,y) co-ordinate system is
    // effectively reversed so even though the direction is down, from our perspective
    // (if we were looking down on the maze) it would be up.
}

/* Function used to check the value of a cell in the maze from any given cell
   (not necessarily the player's current position)
   this function is used a lot in the Drawer (along with other information from the player)
   so it is important the function is not bound to the player's current location
*/
bool Player::checkLocation(Vector2Di origin, double angle, int checkVal) {
    Vector2Di peekDirection = direction;
    peekDirection.rotateVector(angle);
    origin.addVector(peekDirection);
    if (maze->mazeMatrix[origin.y][origin.x] == checkVal) {
        // eg if index == 1 that indicates a solid cell
        // or if index == 2 that is the maze exit 
        return true;
    } else {
        return false;
    }
}

void Player::walk() { 
    if (checkLocation(pos,0,0)) {
        printf("v = (%i, %i)\nwalking\n", pos.x, pos.y);
        pos.addVector(direction); 
        printf("v = (%i, %i)\n", pos.x, pos.y);
    }
};

void Player::turnLeft() { direction.rotateVector(-PI/2); };

void Player::turnRight() { direction.rotateVector(PI/2); };

void Player::stepBack() {
    if (checkLocation(pos,PI,0)) {
        pos.addVector(-direction);
    }
};