#ifndef VICTORYMENU_H
#define VICTORYMENU_H

#include "Menus.h"

// yes button used in the VictoryMenu and the DefeatMenu
/** YesButton Class
 * @brief Derived from Button. Used in VictoryMenu and DefeatMenu.
 * @brief Sends user to the StartMenu.
 */
class YesButton : public Button {
    public:
    YesButton() {
      x = 5;
      y = 32;
    }
    void virtual run() {
      printf("YesButton pushed\n");
      restartFlag = true;
    }
};
// no button used in the VictoryMenu and the DefeatMenu
/** NoButton Class
 * @brief Derived from Button. Used in VictoryMenu and DefeatMenu.
 * @brief Sends user to the MainMenu.
 */
class NoButton : public Button {
    public:
    NoButton() {
      x = 58;
      y = 32;
    }
    void virtual run() {
      printf("NoButton pushed\n");
      menuFlag = true;
    }
};
// VictoryMenu displays when the player escapes the maze, it displays score
// and restart options
/** VictoryMenu Class
 * @brief Derived from Menu. Displayed when the maze is escaped.
 * @brief Or more accurately when the winFlag = true.
 */
class VictoryMenu : public Menu {
    public:
    VictoryMenu(N5110* screenPtr) : Menu(screenPtr) {
        buttons[0] = new YesButton;
        buttons[1] = new NoButton;
        currentButton = buttons[0];
        numOfButtons = 2;
        buttonIndex = 0;
    }
    void virtual draw() {
      std::stringstream sscore;
      sscore << "Score: " << score;
      lcd->printString("VICTORY",10,1);
      lcd->printString(sscore.str().c_str(),10,2);
      lcd->printString("Play again?",10,3);
      lcd->printString("Yes      No",10,4);
    }
    /** Destructor
    */
    ~VictoryMenu() {
        delete buttons[0];
        delete buttons[1];
    }   
};

#endif // VICTORYMENU_H